/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.time.LocalTime;
import java.time.MonthDay;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.aoju.bus.core.date.Converter;
import org.aoju.bus.core.date.formatter.FormatBuilder;

public class Fields {
    public static final String NORM_YEAR_PATTERN = "yyyy";
    public static final FormatBuilder NORM_YEAR_FORMAT = FormatBuilder.getInstance("yyyy");
    public static final String NORM_YEAR_MTOTH_PATTERN = "yyyy-MM";
    public static final FormatBuilder NORM_YEAR_MTOTH_FORMAT = FormatBuilder.getInstance("yyyy-MM");
    public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
    public static final FormatBuilder NORM_DATE_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd");
    public static final String PURE_DATE_PATTERN = "yyyyMMdd";
    public static final FormatBuilder PURE_DATE_FORMAT = FormatBuilder.getInstance("yyyyMMdd");
    public static final String NORM_DATETIME_MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final FormatBuilder NORM_DATETIME_MINUTE_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd HH:mm");
    public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final FormatBuilder NORM_DATETIME_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd HH:mm:ss");
    public static final String NORM_PART_DATETIME_PATTERN = "yyyy-MM-dd hh:mm:ss";
    public static final FormatBuilder NORM_PART_DATETIME_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd hh:mm:ss");
    public static final String NORM_DATETIME_MS_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final FormatBuilder NORM_DATETIME_MS_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd HH:mm:ss.SSS");
    public static final String NORM_DATETIME_ISO8601_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    public static final FormatBuilder NORM_DATETIME_ISO8601_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd HH:mm:ss,SSS");
    public static final String PURE_DATETIME_PATTERN = "yyyyMMddHHmmss";
    public static final FormatBuilder PURE_DATETIME_FORMAT = FormatBuilder.getInstance("yyyyMMddHHmmss");
    public static final String PURE_DATETIME_MS_PATTERN = "yyyyMMddHHmmssSSS";
    public static final FormatBuilder PURE_DATETIME_MS_FORMAT = FormatBuilder.getInstance("yyyyMMddHHmmssSSS");
    public static final String PURE_DATETIME_TIP_PATTERN = "yyyyMMddHHmmss.SSS";
    public static final FormatBuilder PURE_DATETIME_TIP_FORMAT = FormatBuilder.getInstance("yyyyMMddHHmmss.SSS");
    public static final String PURE_DATETIME_ICE_PATTERN = "yyyyMMddHHmmss.SSSSSSZZZZZ";
    public static final FormatBuilder PURE_DATETIME_ICE_FORMAT = FormatBuilder.getInstance("yyyyMMddHHmmss.SSSSSSZZZZZ");
    public static final String NORM_TIME_PATTERN = "HH:mm:ss";
    public static final FormatBuilder NORM_TIME_FORMAT = FormatBuilder.getInstance("HH:mm:ss");
    public static final String PURE_DATE_MINUTE_PATTERN = "yyMMddHHmm";
    public static final FormatBuilder PURE_DATE_MINUTE_FORMAT = FormatBuilder.getInstance("yyMMddHHmm");
    public static final String PURE_DATE_DAY_PATTERN = "MMdd";
    public static final FormatBuilder PURE_DATE_DAY_FORMAT = FormatBuilder.getInstance("MMdd");
    public static final String PURE_TIME_PATTERN = "HHmmss";
    public static final FormatBuilder PURE_TIME_FORMAT = FormatBuilder.getInstance("HHmmss");
    public static final String PURE_TIME_MS_PATTERN = "HHmmssSSS";
    public static final FormatBuilder PURE_TIME_MS_FORMAT = FormatBuilder.getInstance("HHmmssSSS");
    public static final String HOUR_MINUTE_PATTERN = "HH:mm";
    public static final FormatBuilder HOUR_MINUTE_FORMAT = FormatBuilder.getInstance("HH:mm");
    public static final String SHORT_HOUR_MINUTE_PATTERN = "HHmm";
    public static final FormatBuilder SHORT_HOUR_MINUTE_FORMAT = FormatBuilder.getInstance("HHmm");
    public static final String MINUTE_SECOND_PATTERN = "mm:ss";
    public static final FormatBuilder MINUTE_SECOND_FORMAT = FormatBuilder.getInstance("mm:ss");
    public static final String SHORT_MINUTE_SECOND_PATTERN = "mmss";
    public static final FormatBuilder SHORT_MINUTE_SECOND_FORMAT = FormatBuilder.getInstance("mmss");
    public static final String HTTP_DATETIME_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final FormatBuilder HTTP_DATETIME_FORMAT = FormatBuilder.getInstance("EEE, dd MMM yyyy HH:mm:ss z", TimeZone.getTimeZone("GMT"), Locale.US);
    public static final String JDK_DATETIME_PATTERN = "EEE MMM dd HH:mm:ss zzz yyyy";
    public static final FormatBuilder JDK_DATETIME_FORMAT = FormatBuilder.getInstance("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
    public static final String ORM_MONTH_CN_PATTERN = "M\u6708d\u65e5";
    public static final FormatBuilder NORM_MONTH_CN_FORMAT = FormatBuilder.getInstance("M\u6708d\u65e5");
    public static final String NORM_DATE_CN_PATTERN = "yyyy\u5e74M\u6708d\u65e5";
    public static final FormatBuilder NORM_DATE_CN_FORMAT = FormatBuilder.getInstance("yyyy\u5e74M\u6708d\u65e5");
    public static final String NORM_CN_DATE_TIME_PATTERN = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
    public static final FormatBuilder NORM_CN_DATE_TIME_FORMAT = FormatBuilder.getInstance("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
    public static final String UTC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final FormatBuilder UTC_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ss'Z'", TimeZone.getTimeZone("UTC"));
    public static final String MSEC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final FormatBuilder MSEC_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZ", TimeZone.getTimeZone("UTC"));
    public static final String SIMPLE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final FormatBuilder SIMPLE_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ss", TimeZone.getTimeZone("UTC"));
    public static final String SIMPLE_MS_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final FormatBuilder SIMPLE_MS_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSS", TimeZone.getTimeZone("UTC"));
    public static final String SPACEY_PATTERN = "yyyy-MM-dd HH:mm:ss Z";
    public static final FormatBuilder SPACEY_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd HH:mm:ss Z", TimeZone.getTimeZone("UTC"));
    public static final String SPACEY_MSEC_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS Z";
    public static final FormatBuilder SPACEY_MSEC_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd HH:mm:ss.SSS Z", TimeZone.getTimeZone("UTC"));
    public static final String OUTPUT_MSEC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final FormatBuilder OUTPUT_MSEC_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", TimeZone.getTimeZone("UTC"));
    public static final String WITH_ZONE_OFFSET_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final FormatBuilder WITH_ZONE_OFFSET_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ssZ", TimeZone.getTimeZone("UTC"));
    public static final Pattern REGEX_NORM = Pattern.compile("\\d{4}-\\d{1,2}-\\d{1,2}(\\s\\d{1,2}:\\d{1,2}(:\\d{1,2})?)?(.\\d{1,3})?");
    public static final String[] WTB = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    public static final String[] ZODIAC = new String[]{"\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7"};
    public static final int[] SLICED = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
    public static final String[] CN_ANIMAL = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    public static final String[] CN_GAN = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    public static final String[] CN_ZHI = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    public static final String[] CN_YEAR = new String[]{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    public static final String[] CN_MONTH = new String[]{"\u6b63", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u51ac", "\u814a"};
    public static final String[] CN_DAY = new String[]{"\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u5eff\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u5345\u5341"};
    public static final String[] CN_JIA_ZI = new String[]{"\u7532\u5b50", "\u4e59\u4e11", "\u4e19\u5bc5", "\u4e01\u536f", "\u620a\u8fb0", "\u5df1\u5df3", "\u5e9a\u5348", "\u8f9b\u672a", "\u58ec\u7533", "\u7678\u9149", "\u7532\u620c", "\u4e59\u4ea5", "\u4e19\u5b50", "\u4e01\u4e11", "\u620a\u5bc5", "\u5df1\u536f", "\u5e9a\u8fb0", "\u8f9b\u5df3", "\u58ec\u5348", "\u7678\u672a", "\u7532\u7533", "\u4e59\u9149", "\u4e19\u620c", "\u4e01\u4ea5", "\u620a\u5b50", "\u5df1\u4e11", "\u5e9a\u5bc5", "\u8f9b\u536f", "\u58ec\u8fb0", "\u7678\u5df3", "\u7532\u5348", "\u4e59\u672a", "\u4e19\u7533", "\u4e01\u9149", "\u620a\u620c", "\u5df1\u4ea5", "\u5e9a\u5b50", "\u8f9b\u4e11", "\u58ec\u5bc5", "\u7678\u536f", "\u7532\u8fb0", "\u4e59\u5df3", "\u4e19\u5348", "\u4e01\u672a", "\u620a\u7533", "\u5df1\u9149", "\u5e9a\u620c", "\u8f9b\u4ea5", "\u58ec\u5b50", "\u7678\u4e11", "\u7532\u5bc5", "\u4e59\u536f", "\u4e19\u8fb0", "\u4e01\u5df3", "\u620a\u5348", "\u5df1\u672a", "\u5e9a\u7533", "\u8f9b\u9149", "\u58ec\u620c", "\u7678\u4ea5"};
    public static final String[] CN_SEASON = new String[]{"\u5b5f\u6625", "\u4ef2\u6625", "\u5b63\u6625", "\u5b5f\u590f", "\u4ef2\u590f", "\u5b63\u590f", "\u5b5f\u79cb", "\u4ef2\u79cb", "\u5b63\u79cb", "\u5b5f\u51ac", "\u4ef2\u51ac", "\u5b63\u51ac"};
    public static final String[] CN_JIE = new String[]{"\u5c0f\u5bd2", "\u7acb\u6625", "\u60ca\u86f0", "\u6e05\u660e", "\u7acb\u590f", "\u8292\u79cd", "\u5c0f\u6691", "\u7acb\u79cb", "\u767d\u9732", "\u5bd2\u9732", "\u7acb\u51ac", "\u5927\u96ea"};
    public static final String[] CN_QI = new String[]{"\u5927\u5bd2", "\u96e8\u6c34", "\u6625\u5206", "\u8c37\u96e8", "\u5c0f\u6ee1", "\u590f\u81f3", "\u5927\u6691", "\u5904\u6691", "\u79cb\u5206", "\u971c\u964d", "\u5c0f\u96ea", "\u51ac\u81f3"};
    public static final String[] CN_SOLARTERM = new String[]{"\u51ac\u81f3", "\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea"};
    public static final int[] DAYS_OF_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int[] LEAP_YEAR = new int[]{6, 14, 19, 25, 33, 36, 38, 41, 44, 52, 55, 79, 117, 136, 147, 150, 155, 158, 185, 193};
    public static final int[] LEAP_MONTH = new int[]{0, 4, 173, 8, 90, 1, 213, 84, 180, 9, 100, 5, 89, 69, 149, 10, 166, 4, 85, 36, 173, 8, 90, 98, 218, 4, 180, 5, 180, 85, 82, 13, 148, 10, 74, 42, 86, 2, 109, 113, 109, 1, 218, 2, 210, 82, 169, 5, 73, 13, 42, 69, 43, 9, 86, 1, 181, 32, 109, 1, 89, 105, 212, 10, 168, 5, 169, 86, 165, 4, 43, 9, 158, 56, 182, 8, 236, 116, 108, 5, 212, 10, 228, 106, 82, 5, 149, 10, 90, 66, 91, 4, 182, 4, 180, 34, 106, 5, 82, 117, 201, 10, 82, 5, 53, 85, 77, 10, 90, 2, 93, 49, 181, 2, 106, 138, 104, 5, 169, 10, 138, 106, 42, 5, 45, 9, 170, 72, 90, 1, 181, 9, 176, 57, 100, 5, 37, 117, 149, 10, 150, 4, 77, 84, 173, 4, 218, 4, 212, 68, 180, 5, 84, 133, 82, 13, 146, 10, 86, 106, 86, 2, 109, 2, 106, 65, 218, 2, 178, 161, 169, 5, 73, 13, 10, 109, 42, 9, 86, 1, 173, 80, 109, 1, 217, 2, 209, 58, 168, 5, 41, 133, 165, 12, 42, 9, 150, 84, 182, 8, 108, 9, 100, 69, 212, 10, 164, 5, 81, 37, 149, 10, 42, 114, 91, 4, 182, 4, 172, 82, 106, 5, 210, 10, 162, 74, 74, 5, 85, 148, 45, 10, 90, 2, 117, 97, 181, 2, 106, 3, 97, 69, 169, 10, 74, 5, 37, 37, 45, 9, 154, 104, 218, 8, 180, 9, 168, 89, 84, 3, 165, 10, 145, 58, 150, 4, 173, 176, 173, 4, 218, 4, 244, 98, 180, 5, 84, 11, 68, 93, 82, 10, 149, 4, 85, 34, 109, 2, 90, 113, 218, 2, 170, 5, 178, 85, 73, 11, 74, 10, 45, 57, 54, 1, 109, 128, 109, 1, 217, 2, 233, 106, 168, 5, 41, 11, 154, 76, 170, 8, 182, 8, 180, 56, 108, 9, 84, 117, 212, 10, 164, 5, 69, 85, 149, 10, 154, 4, 85, 68, 181, 4, 106, 130, 106, 5, 210, 10, 146, 106, 74, 5, 85, 10, 42, 74, 90, 2, 181, 2, 178, 49, 105, 3, 49, 115, 169, 10, 74, 5, 45, 85, 45, 9, 90, 1, 213, 72, 180, 9, 104, 137, 84, 11, 164, 10, 165, 106, 149, 4, 173, 8, 106, 68, 218, 4, 116, 5, 176, 37, 84, 3};
    public static String[] CN_HOLIDAY = new String[]{"\u5143\u65e6\u8282", "\u6625\u8282", "\u6e05\u660e\u8282", "\u52b3\u52a8\u8282", "\u7aef\u5348\u8282", "\u4e2d\u79cb\u8282", "\u56fd\u5e86\u8282", "\u56fd\u5e86\u4e2d\u79cb", "\u6297\u6218\u80dc\u5229\u65e5"};

    public static enum Modify {
        TRUNCATE,
        ROUND,
        CEILING;

    }

    public static enum Zodiac {
        Aries(1, "\u767d\u7f8a\u5ea7", "03-21", "04-19"),
        Taurus(2, "\u91d1\u725b\u5ea7", "04-20", "05-20"),
        Gemini(3, "\u53cc\u5b50\u5ea7", "05-21", "06-21"),
        Cancer(4, "\u5de8\u87f9\u5ea7", "06-22", "07-22"),
        Leo(5, "\u72ee\u5b50\u5ea7", "07-23", "08-22"),
        Virgo(6, "\u5904\u5973\u5ea7", "08-23", "09-22"),
        Libra(7, "\u5929\u79e4\u5ea7", "09-23", "10-23"),
        Scorpio(8, "\u5929\u874e\u5ea7", "10-24", "11-22"),
        Sagittarius(9, "\u5c04\u624b\u5ea7", "11-23", "12-21"),
        Capricorn(10, "\u6469\u7faf\u5ea7", "12-22", "01-19"),
        Aquarius(11, "\u6c34\u74f6\u5ea7", "01-20", "02-18"),
        Pisces(12, "\u53cc\u9c7c\u5ea7", "02-19", "03-20");

        private final int key;
        private final String name;
        private final String startDate;
        private final String endDate;

        private Zodiac(int key, String name, String startDate, String endDate) {
            this.key = key;
            this.name = name;
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public static Zodiac getZodiacByMonthDay(String monthDayStr) {
            MonthDay monthDay = MonthDay.parse("--" + monthDayStr);
            for (Zodiac zodiac : Zodiac.values()) {
                if (zodiac.startDate.equals(monthDayStr) || zodiac.endDate.equals(monthDayStr)) {
                    return zodiac;
                }
                if (Zodiac.isCapricorn(monthDay)) {
                    return Capricorn;
                }
                MonthDay monthDayStart = MonthDay.parse("--" + zodiac.startDate);
                MonthDay monthDayEnd = MonthDay.parse("--" + zodiac.endDate);
                if (!monthDay.isAfter(monthDayStart) || !monthDay.isBefore(monthDayEnd)) continue;
                return zodiac;
            }
            return null;
        }

        private static boolean isCapricorn(MonthDay monthDay) {
            MonthDay capricorn_start = MonthDay.parse("--12-22");
            MonthDay capricorn_end = MonthDay.parse("--01-19");
            if (capricorn_start.equals(monthDay) || capricorn_end.equals(monthDay)) {
                return true;
            }
            if (monthDay.isAfter(capricorn_start) && monthDay.isBefore(capricorn_end)) {
                return true;
            }
            return monthDay.isAfter(capricorn_start) && monthDay.isBefore(capricorn_end);
        }

        public static String getCnNameByMonthDay(String monthDayStr) {
            Zodiac zodiac = Zodiac.getZodiacByMonthDay(monthDayStr);
            return null != zodiac ? zodiac.name : null;
        }

        public static String getEnNameByMonthDay(String monthDayStr) {
            Zodiac zodiac = Zodiac.getZodiacByMonthDay(monthDayStr);
            return null != zodiac ? zodiac.name() : null;
        }

        public int getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getStartDate() {
            return this.startDate;
        }

        public String getEndDate() {
            return this.endDate;
        }
    }

    public static enum Week {
        Sun(1, "Sunday", "\u661f\u671f\u65e5"),
        Mon(2, "Monday", "\u661f\u671f\u4e00"),
        Tue(3, "Tuesday", "\u661f\u671f\u4e8c"),
        Wed(4, "Wednesday", "\u661f\u671f\u4e09"),
        Thu(5, "Thursday", "\u661f\u671f\u56db"),
        Fri(6, "Friday", "\u661f\u671f\u4e94"),
        Sat(7, "Saturday", "\u661f\u671f\u516d");

        private final int key;
        private final String enName;
        private final String cnName;

        private Week(int key, String enName, String cnName) {
            this.key = key;
            this.enName = enName;
            this.cnName = cnName;
        }

        public static Week getByCode(int code) {
            if (code >= 1 && code <= 12) {
                for (Week week : Week.values()) {
                    if (week.key != code) continue;
                    return week;
                }
            }
            return null;
        }

        public static String getShortNameByCode(int code) {
            Week week = Week.getByCode(code);
            return null != week ? week.name() : null;
        }

        public static String getEnNameByCode(int code) {
            Week week = Week.getByCode(code);
            return null != week ? week.enName : null;
        }

        public static String getCnNameByCode(int code) {
            Week week = Week.getByCode(code);
            return null != week ? week.cnName : null;
        }

        public int getKey() {
            return this.key;
        }

        public String getEnName() {
            return this.enName;
        }

        public String getCnName() {
            return this.cnName;
        }
    }

    public static enum Quarter {
        Q1(1, "\u4e00\u5b63\u5ea6"),
        Q2(2, "\u4e8c\u5b63\u5ea6"),
        Q3(3, "\u4e09\u5b63\u5ea6"),
        Q4(4, "\u56db\u5b63\u5ea6");

        private final int key;
        private final String name;

        private Quarter(int key, String name) {
            this.key = key;
            this.name = name;
        }

        public static Quarter of(int intValue) {
            switch (intValue) {
                case 1: {
                    return Q1;
                }
                case 2: {
                    return Q2;
                }
                case 3: {
                    return Q3;
                }
                case 4: {
                    return Q4;
                }
            }
            return null;
        }

        public int getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Month {
        Jan(0, "January", "\u4e00\u6708", "\u4e00"),
        Feb(1, "February", "\u4e8c\u6708", "\u4e8c"),
        Mar(2, "March", "\u4e09\u6708", "\u4e09"),
        Apr(3, "April", "\u56db\u6708", "\u56db"),
        May(4, "May", "\u4e94\u6708", "\u4e94"),
        Jun(5, "June", "\u516d\u6708", "\u516d"),
        Jul(6, "July", "\u4e03\u6708", "\u4e03"),
        Aug(7, "August", "\u516b\u6708", "\u516b"),
        Sep(8, "September", "\u4e5d\u6708", "\u4e5d"),
        Oct(9, "October", "\u5341\u6708", "\u5341"),
        Nov(10, "November", "\u5341\u4e00\u6708", "\u5341\u4e00"),
        Dec(11, "December", "\u5341\u4e8c\u6708", "\u5341\u4e8c"),
        Und(12, "Undecimber", "\u5341\u4e09\u6708", "\u5341\u4e09");

        private static final int[] MOHTH_OF_LASTDAY;
        private final int key;
        private final String enName;
        private final String cnName;
        private final String shortName;

        private Month(int key, String enName, String cnName, String shortName) {
            this.key = key;
            this.enName = enName;
            this.cnName = cnName;
            this.shortName = shortName;
        }

        public static Month getByCode(int code) {
            if (code >= 1 && code <= 12) {
                for (Month month : Month.values()) {
                    if (month.key != code) continue;
                    return month;
                }
            }
            return null;
        }

        public static String getShortNameEnByCode(int code) {
            Month month = Month.getByCode(code);
            return null != month ? month.name() : null;
        }

        public static String getFullNameEnByCode(int code) {
            Month month = Month.getByCode(code);
            return null != month ? month.enName : null;
        }

        public static String getFullNameCnByCode(int code) {
            Month month = Month.getByCode(code);
            return null != month ? month.cnName : null;
        }

        public static String getShortNameCnByCode(int code) {
            Month month = Month.getByCode(code);
            return null != month ? month.shortName : null;
        }

        public static int getLastDay(int month, boolean isLeapYear) {
            int lastDay = MOHTH_OF_LASTDAY[month];
            if (isLeapYear && 1 == month) {
                ++lastDay;
            }
            return lastDay;
        }

        public int getLastDay(boolean isLeapYear) {
            return Month.getLastDay(this.key, isLeapYear);
        }

        public int getKey() {
            return this.key;
        }

        public String getEnName() {
            return this.enName;
        }

        public String getCnName() {
            return this.cnName;
        }

        public String getShortName() {
            return this.shortName;
        }

        static {
            MOHTH_OF_LASTDAY = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, -1};
        }
    }

    public static enum Chrono {
        ZISHI(1, "\u5b50\u65f6", "23:00:00", "01:00:00"),
        CHOUSHI(2, "\u4e11\u65f6", "01:00:00", "03:00:00"),
        YINSHI(3, "\u5bc5\u65f6", "03:00:00", "05:00:00"),
        MAOSHI(4, "\u536f\u8fb0", "05:00:00", "07:00:00"),
        CHENSHI(5, "\u8fb0\u65f6", "07:00:00", "09:00:00"),
        SISHI(6, "\u5df3\u65f6", "09:00:00", "11:00:00"),
        WUSHI(7, "\u5348\u65f6", "11:00:00", "13:00:00"),
        WEISHI(8, "\u672a\u65f6", "13:00:00", "15:00:00"),
        SHENSHI(9, "\u7533\u65f6", "15:00:00", "17:00:00"),
        YOUSHI(10, "\u9149\u65f6", "17:00:00", "19:00:00"),
        XUSHI(11, "\u620c\u65f6", "19:00:00", "21:00:00"),
        HAISHI(12, "\u4ea5\u65f6", "21:00:00", "23:00:00");

        private final int key;
        private final String name;
        private final String startTime;
        private final String endTime;

        private Chrono(int key, String name, String startTime, String endTime) {
            this.key = key;
            this.name = name;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public static Chrono getChrono(LocalTime localTime) {
            for (Chrono chrono : Chrono.values()) {
                if (Chrono.isZiShi(localTime)) {
                    return ZISHI;
                }
                if (!Chrono.isBetween(localTime, LocalTime.parse(chrono.startTime), LocalTime.parse(chrono.endTime))) continue;
                return chrono;
            }
            return null;
        }

        private static boolean isBetween(LocalTime localTime, LocalTime timeStart, LocalTime timeEnd) {
            return localTime.equals(timeStart) || localTime.isAfter(timeStart) && localTime.isBefore(timeEnd);
        }

        private static boolean isZiShi(LocalTime localTime) {
            if (LocalTime.of(23, 0, 0).equals(localTime) || LocalTime.MIDNIGHT.equals(localTime)) {
                return true;
            }
            if (localTime.isAfter(LocalTime.of(23, 0, 0)) && localTime.isBefore(LocalTime.MIDNIGHT)) {
                return true;
            }
            return localTime.isAfter(LocalTime.MIDNIGHT) && localTime.isBefore(LocalTime.of(1, 0, 0));
        }

        public static String getName(LocalTime localTime) {
            Chrono chrono = Chrono.getChrono(localTime);
            return null != chrono ? chrono.name : null;
        }

        public static String getName(java.util.Date date) {
            return Chrono.getName(Converter.toLocalTime(date));
        }

        public int getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }
    }

    public static enum Date {
        TODAY("today", "\u4eca\u5929"),
        TOMORROW("tomorrow", "\u660e\u5929"),
        NEXTWEEK("nextWeek", "\u4e0b\u5468"),
        NEXTMONTH("nextMonth", "\u4e0b\u6708"),
        NEXTYEAR("nextYear", "\u660e\u5e74"),
        YESTERDAY("yesterday", "\u6628\u5929"),
        LASTWEEK("lastWeek", "\u4e0a\u5468"),
        LASTMONTH("lastMonth", "\u4e0a\u6708"),
        LASTYEAR("lastYear", "\u53bb\u5e74");

        private final String key;
        private final String name;

        private Date(String key, String name) {
            this.key = key;
            this.name = name;
        }

        public static Map<String, String> convertToMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Date date : Date.values()) {
                map.put(date.key, date.key);
                map.put(date.name, date.key);
            }
            return map;
        }

        public static Date getByCode(String code) {
            for (Date date : Date.values()) {
                if (!date.key.equals(code)) continue;
                return date;
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Units {
        MILLISECOND(1L, "\u6beb\u79d2"),
        SECOND(1000L, "\u79d2"),
        MINUTE(SECOND.getUnit() * 60L, "\u5206"),
        HOUR(MINUTE.getUnit() * 60L, "\u5c0f\u65f6"),
        DAY(HOUR.getUnit() * 24L, "\u5929"),
        WEEK(DAY.getUnit() * 7L, "\u5468");

        private final long unit;
        private final String name;

        private Units(long unit, String name) {
            this.unit = unit;
            this.name = name;
        }

        public long getUnit() {
            return this.unit;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Type {
        ERA(0),
        YEAR(1),
        MONTH(2),
        WEEK_OF_YEAR(3),
        WEEK_OF_MONTH(4),
        DAY_OF_MONTH(5),
        DAY_OF_YEAR(6),
        DAY_OF_WEEK(7),
        DAY_OF_WEEK_IN_MONTH(8),
        AM_PM(9),
        HOUR(10),
        HOUR_OF_DAY(11),
        MINUTE(12),
        SECOND(13),
        MILLISECOND(14);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type of(int calendarPartIntValue) {
            switch (calendarPartIntValue) {
                case 0: {
                    return ERA;
                }
                case 1: {
                    return YEAR;
                }
                case 2: {
                    return MONTH;
                }
                case 3: {
                    return WEEK_OF_YEAR;
                }
                case 4: {
                    return WEEK_OF_MONTH;
                }
                case 5: {
                    return DAY_OF_MONTH;
                }
                case 6: {
                    return DAY_OF_YEAR;
                }
                case 7: {
                    return DAY_OF_WEEK;
                }
                case 8: {
                    return DAY_OF_WEEK_IN_MONTH;
                }
                case 9: {
                    return AM_PM;
                }
                case 10: {
                    return HOUR;
                }
                case 11: {
                    return HOUR_OF_DAY;
                }
                case 12: {
                    return MINUTE;
                }
                case 13: {
                    return SECOND;
                }
                case 14: {
                    return MILLISECOND;
                }
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }
}

