/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.toolkit.ArrayKit;

public class CharKit {
    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isAsciiControl(char ch) {
        return ch < ' ' || ch == '\u007f';
    }

    public static boolean isLetter(char ch) {
        return CharKit.isLetterUpper(ch) || CharKit.isLetterLower(ch);
    }

    public static boolean isLetterUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isLetterLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isHexChar(char c) {
        return CharKit.isNumber(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static boolean isLetterOrNumber(char ch) {
        return CharKit.isLetter(ch) || CharKit.isNumber(ch);
    }

    public static boolean isCharClass(Class<?> clazz) {
        return clazz == Character.class || clazz == Character.TYPE;
    }

    public static boolean isChar(Object value) {
        return value instanceof Character || value.getClass() == Character.TYPE;
    }

    public static boolean isBlankChar(char c) {
        return CharKit.isBlankChar((int)c);
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0;
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharKit.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence str) {
        return false == CharKit.isBlank(str);
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        if (ArrayKit.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!CharKit.isNotBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return false == CharKit.isEmpty(str);
    }

    public static boolean isAllEmpty(CharSequence ... strs) {
        if (ArrayKit.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!CharKit.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(CharSequence ... args) {
        return false == CharKit.hasEmpty(args);
    }

    public static boolean isAllNotBlank(CharSequence ... args) {
        return false == CharKit.hasBlank(args);
    }

    public static boolean isNullOrUndefined(CharSequence str) {
        if (null == str) {
            return true;
        }
        return CharKit.isNullOrUndefinedStr(str);
    }

    public static boolean isEmptyOrUndefined(CharSequence str) {
        if (CharKit.isEmpty(str)) {
            return true;
        }
        return CharKit.isNullOrUndefinedStr(str);
    }

    public static boolean isBlankOrUndefined(CharSequence str) {
        if (CharKit.isBlank(str)) {
            return true;
        }
        return CharKit.isNullOrUndefinedStr(str);
    }

    private static boolean isNullOrUndefinedStr(CharSequence str) {
        String strString = str.toString().trim();
        return "null".equals(strString) || "undefined".equals(strString);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        if (ArrayKit.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!CharKit.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEmpty(CharSequence ... strs) {
        if (ArrayKit.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!CharKit.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmoji(char c) {
        return false == (c == '\u0000' || c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff');
    }

    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        if (ignoreCase) {
            return Character.toLowerCase(c1) == Character.toLowerCase(c2);
        }
        return c1 == c2;
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (CharKit.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (CharKit.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String toString(char c) {
        String[] CACHE = new String[128];
        for (char i = '\u0000'; i < '\u0080'; i = (char)(i + '\u0001')) {
            CACHE[i] = String.valueOf(i);
        }
        return c < '\u0080' ? CACHE[c] : String.valueOf(c);
    }

    public static boolean isFileSeparator(char c) {
        return '/' == c || '\\' == c;
    }

    public static int compare(char x, char y) {
        return x - y;
    }

    public static char[] getChars(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes).flip();
        CharBuffer cb = Charset.UTF_8.decode(bb);
        return cb.array();
    }

    public static char byteToChar(byte[] b) {
        int hi = (b[0] & 0xFF) << 8;
        int lo = b[1] & 0xFF;
        return (char)(hi | lo);
    }

    public static char toCloseChar(char c) {
        int result = c;
        if (c >= 49 && c <= 57) {
            result = 9312 + c - 49;
        } else if (c >= 65 && c <= 90) {
            result = 9398 + c - 65;
        } else if (c >= 97 && c <= 122) {
            result = 9424 + c - 97;
        }
        return (char)result;
    }

    public static char toCloseByNumber(int number) {
        if (number > 20) {
            throw new IllegalArgumentException("Number must be [1-20]");
        }
        return (char)(9312 + number - 1);
    }

    public static boolean startWithNumber(CharSequence str) {
        return CharKit.isNotBlank(str) && RegEx.NUMBERS.matcher(str.subSequence(0, 1)).find();
    }

    public static boolean startWithGeneral(CharSequence str) {
        return CharKit.isNotBlank(str) && RegEx.GENERAL.matcher(str.subSequence(0, 1)).find();
    }

    public static boolean startWithWord(CharSequence str) {
        return CharKit.isNotBlank(str) && RegEx.WORD.matcher(str.subSequence(0, 1)).find();
    }

    public static boolean startWithChinese(CharSequence str) {
        return CharKit.isNotBlank(str) && RegEx.CHINESES.matcher(str.subSequence(0, 1)).find();
    }
}

