/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.io.streams.ByteArrayOutputStream;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class RuntimeKit {
    public static String execForStr(String ... cmds) throws InstrumentException {
        return RuntimeKit.execForStr(Charset.systemCharset(), cmds);
    }

    public static String execForStr(java.nio.charset.Charset charset, String ... cmds) throws InstrumentException {
        return RuntimeKit.getResult(RuntimeKit.exec(cmds), charset);
    }

    public static List<String> execForLines(String ... cmds) throws InstrumentException {
        return RuntimeKit.execForLines(Charset.systemCharset(), cmds);
    }

    public static List<String> execForLines(java.nio.charset.Charset charset, String ... cmds) throws InstrumentException {
        return RuntimeKit.getResultLines(RuntimeKit.exec(cmds), charset);
    }

    public static Process exec(String ... cmds) {
        Process process;
        if (ArrayKit.isEmpty(cmds)) {
            throw new NullPointerException("Command is empty !");
        }
        if (1 == cmds.length) {
            String cmd = cmds[0];
            if (StringKit.isBlank(cmd)) {
                throw new NullPointerException("Command is empty !");
            }
            cmds = StringKit.splitToArray(cmd, 32);
        }
        try {
            process = new ProcessBuilder(cmds).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return process;
    }

    public static Process exec(String[] envp, String ... cmds) {
        return RuntimeKit.exec(envp, null, cmds);
    }

    public static Process exec(String[] envp, File dir, String ... cmds) {
        if (ArrayKit.isEmpty(cmds)) {
            throw new NullPointerException("Command is empty !");
        }
        if (1 == cmds.length) {
            String cmd = cmds[0];
            if (StringKit.isBlank(cmd)) {
                throw new NullPointerException("Command is empty !");
            }
            cmds = StringKit.splitToArray(cmd, 32);
        }
        try {
            return Runtime.getRuntime().exec(cmds, envp, dir);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static List<String> getResultLines(Process process) {
        return RuntimeKit.getResultLines(process, Charset.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResultLines(Process process, java.nio.charset.Charset charset) {
        InputStream in = null;
        try {
            in = process.getInputStream();
            List list = IoKit.readLines(in, charset, new ArrayList());
            return list;
        }
        finally {
            IoKit.close(in);
            RuntimeKit.destroy(process);
        }
    }

    public static String getResult(Process process) {
        return RuntimeKit.getResult(process, Charset.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResult(Process process, java.nio.charset.Charset charset) {
        InputStream in = null;
        try {
            in = process.getInputStream();
            String string = IoKit.read(in, charset);
            return string;
        }
        finally {
            IoKit.close(in);
            RuntimeKit.destroy(process);
        }
    }

    public static String getErrorResult(Process process) {
        return RuntimeKit.getErrorResult(process, Charset.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorResult(Process process, java.nio.charset.Charset charset) {
        InputStream in = null;
        try {
            in = process.getErrorStream();
            String string = IoKit.read(in, charset);
            return string;
        }
        finally {
            IoKit.close(in);
            RuntimeKit.destroy(process);
        }
    }

    public static void destroy(Process process) {
        if (null != process) {
            process.destroy();
        }
    }

    public static void addShutdownHook(Runnable hook) {
        Runtime.getRuntime().addShutdownHook(hook instanceof Thread ? (Thread)hook : new Thread(hook));
    }

    public static int getPid() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        String[] split = jvmName.split("@");
        if (split.length != 2) {
            return -1;
        }
        try {
            return Integer.parseInt(split[0]);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static long getUpTime() {
        return ManagementFactory.getRuntimeMXBean().getUptime();
    }

    public static String getVmArguments() {
        List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        return CollKit.join(vmArguments, (CharSequence)" ");
    }

    public static String getMessage(Throwable e) {
        if (null == e) {
            return "null";
        }
        return StringKit.format("{}: {}", e.getClass().getSimpleName(), e.getMessage());
    }

    public static String getSimpleMessage(Throwable e) {
        return null == e ? "null" : e.getMessage();
    }

    public static RuntimeException wrapRuntime(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static RuntimeException wrapRuntime(String message) {
        return new RuntimeException(message);
    }

    public static <T extends Throwable> T wrap(Throwable throwable, Class<T> wrapThrowable) {
        if (wrapThrowable.isInstance(throwable)) {
            return (T)throwable;
        }
        return (T)((Throwable)ReflectKit.newInstance(wrapThrowable, throwable));
    }

    public static void wrapAndThrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }

    public static void wrapRuntimeAndThrow(String message) {
        throw new RuntimeException(message);
    }

    public static Throwable unwrap(Throwable wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }

    public static StackTraceElement[] getStackElements() {
        return Thread.currentThread().getStackTrace();
    }

    public static StackTraceElement getStackElement(int layers) {
        return RuntimeKit.getStackElements()[layers];
    }

    public static StackTraceElement getStackElement(String fqcn, int layers) {
        StackTraceElement[] stackTraceArray = RuntimeKit.getStackElements();
        int index = ArrayKit.firstNonAll(ele -> StringKit.equals(fqcn, ele.getClassName()), stackTraceArray);
        if (index > 0) {
            return stackTraceArray[index + layers];
        }
        return null;
    }

    public static StackTraceElement getRootStackElement() {
        StackTraceElement[] stackElements = RuntimeKit.getStackElements();
        return stackElements[stackElements.length - 1];
    }

    public static String getStackTraceOneLine(Throwable throwable) {
        return RuntimeKit.getStackTraceOneLine(throwable, 3000);
    }

    public static String getStackTraceOneLine(Throwable throwable, int limit) {
        HashMap<Character, String> replaceCharToStrMap = new HashMap<Character, String>();
        replaceCharToStrMap.put(Character.valueOf('\r'), " ");
        replaceCharToStrMap.put(Character.valueOf('\n'), " ");
        replaceCharToStrMap.put(Character.valueOf('\t'), " ");
        return RuntimeKit.getStackTrace(throwable, limit, replaceCharToStrMap);
    }

    public static String getStackTrace(Throwable throwable) {
        return RuntimeKit.getStackTrace(throwable, 3000);
    }

    public static String getStackTrace(Throwable throwable, int limit) {
        return RuntimeKit.getStackTrace(throwable, limit, null);
    }

    public static String getStackTrace(Throwable throwable, int limit, Map<Character, String> replaceCharToStrMap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(baos));
        String exceptionStr = baos.toString();
        int length = exceptionStr.length();
        if (limit > 0 && limit < length) {
            length = limit;
        }
        if (CollKit.isNotEmpty(replaceCharToStrMap)) {
            StringBuilder sb = StringKit.builder();
            for (int i = 0; i < length; ++i) {
                char c = exceptionStr.charAt(i);
                String value = replaceCharToStrMap.get(Character.valueOf(c));
                if (null != value) {
                    sb.append(value);
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return StringKit.subPre(exceptionStr, limit);
    }

    public static boolean isCausedBy(Throwable throwable, Class<? extends Exception> ... causeClasses) {
        return null != RuntimeKit.getCausedBy(throwable, causeClasses);
    }

    public static Throwable getCausedBy(Throwable throwable, Class<? extends Exception> ... causeClasses) {
        for (Throwable cause = throwable; null != cause; cause = cause.getCause()) {
            for (Class<? extends Exception> causeClass : causeClasses) {
                if (!causeClass.isInstance(cause)) continue;
                return cause;
            }
        }
        return null;
    }

    public static boolean isFromOrSuppressedThrowable(Throwable throwable, Class<? extends Throwable> exceptionClass) {
        return null != RuntimeKit.convertFromOrSuppressedThrowable(throwable, exceptionClass, true);
    }

    public static boolean isFromOrSuppressedThrowable(Throwable throwable, Class<? extends Throwable> exceptionClass, boolean checkCause) {
        return null != RuntimeKit.convertFromOrSuppressedThrowable(throwable, exceptionClass, checkCause);
    }

    public static <T extends Throwable> T convertFromOrSuppressedThrowable(Throwable throwable, Class<T> exceptionClass) {
        return RuntimeKit.convertFromOrSuppressedThrowable(throwable, exceptionClass, true);
    }

    public static <T extends Throwable> T convertFromOrSuppressedThrowable(Throwable throwable, Class<T> exceptionClass, boolean checkCause) {
        Throwable cause;
        if (null == throwable || null == exceptionClass) {
            return null;
        }
        if (exceptionClass.isAssignableFrom(throwable.getClass())) {
            return (T)throwable;
        }
        if (checkCause && null != (cause = throwable.getCause()) && exceptionClass.isAssignableFrom(cause.getClass())) {
            return (T)cause;
        }
        Throwable[] throwables = throwable.getSuppressed();
        if (ArrayKit.isNotEmpty(throwables)) {
            for (Throwable throwable1 : throwables) {
                if (!exceptionClass.isAssignableFrom(throwable1.getClass())) continue;
                return (T)throwable1;
            }
        }
        return null;
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (null != throwable && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return list;
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list = RuntimeKit.getThrowableList(throwable);
        return list.size() < 1 ? null : list.get(list.size() - 1);
    }

    public static String getRootCauseMessage(Throwable th) {
        return RuntimeKit.getMessage(RuntimeKit.getRootCause(th));
    }
}

