/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.software;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractInternetProtocolStats;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;
import org.aoju.bus.health.linux.ProcPath;
import org.aoju.bus.health.linux.drivers.ProcessStat;
import org.aoju.bus.health.unix.NetStat;

@ThreadSafe
public class LinuxInternetProtocolStats
extends AbstractInternetProtocolStats {
    private static InternetProtocolStats.TcpStats getTcpStats(String netstatStr) {
        long connectionsEstablished = 0L;
        long connectionsActive = 0L;
        long connectionsPassive = 0L;
        long connectionFailures = 0L;
        long connectionsReset = 0L;
        long segmentsSent = 0L;
        long segmentsReceived = 0L;
        long segmentsRetransmitted = 0L;
        long inErrors = 0L;
        long outResets = 0L;
        List<String> netstat = Executor.runNative(netstatStr);
        for (String s : netstat) {
            String[] split = s.trim().split(" ", 2);
            if (split.length != 2) continue;
            switch (split[1]) {
                case "connections established": {
                    connectionsEstablished = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "active connection openings": {
                    connectionsActive = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "passive connection openings": {
                    connectionsPassive = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "failed connection attempts": {
                    connectionFailures = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "connection resets received": {
                    connectionsReset = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "segments sent out": {
                    segmentsSent = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "segments received": {
                    segmentsReceived = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "segments retransmitted": {
                    segmentsRetransmitted = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "bad segments received": {
                    inErrors = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "resets sent": {
                    outResets = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
            }
        }
        return new InternetProtocolStats.TcpStats(connectionsEstablished, connectionsActive, connectionsPassive, connectionFailures, connectionsReset, segmentsSent, segmentsReceived, segmentsRetransmitted, inErrors, outResets);
    }

    private static InternetProtocolStats.UdpStats getUdpStats(String netstatStr) {
        long datagramsSent = 0L;
        long datagramsReceived = 0L;
        long datagramsNoPort = 0L;
        long datagramsReceivedErrors = 0L;
        List<String> netstat = Executor.runNative(netstatStr);
        for (String s : netstat) {
            String[] split = s.trim().split(" ", 2);
            if (split.length != 2) continue;
            switch (split[1]) {
                case "packets sent": {
                    datagramsSent = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "packets received": {
                    datagramsReceived = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "packets to unknown port received": {
                    datagramsNoPort = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "packet receive errors": {
                    datagramsReceivedErrors = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
            }
        }
        return new InternetProtocolStats.UdpStats(datagramsSent, datagramsReceived, datagramsNoPort, datagramsReceivedErrors);
    }

    private static List<InternetProtocolStats.IPConnection> queryConnections(String protocol, int ipver, Map<Integer, Integer> pidMap) {
        ArrayList<InternetProtocolStats.IPConnection> conns = new ArrayList<InternetProtocolStats.IPConnection>();
        for (String s : FileKit.readLines(ProcPath.NET + "/" + protocol + (ipver == 6 ? "6" : ""))) {
            String[] split;
            if (s.indexOf(58) < 0 || (split = RegEx.SPACES.split(s.trim())).length <= 9) continue;
            Pair<byte[], Integer> lAddr = LinuxInternetProtocolStats.parseIpAddr(split[1]);
            Pair<byte[], Integer> fAddr = LinuxInternetProtocolStats.parseIpAddr(split[2]);
            InternetProtocolStats.TcpState state = LinuxInternetProtocolStats.stateLookup(Builder.hexStringToInt(split[3], 0));
            Pair<Integer, Integer> txQrxQ = LinuxInternetProtocolStats.parseHexColonHex(split[4]);
            int inode = Builder.parseIntOrDefault(split[9], 0);
            conns.add(new InternetProtocolStats.IPConnection(protocol + ipver, lAddr.getLeft(), lAddr.getRight(), fAddr.getLeft(), fAddr.getRight(), state, txQrxQ.getLeft(), txQrxQ.getRight(), pidMap.getOrDefault(inode, -1)));
        }
        return conns;
    }

    private static Pair<byte[], Integer> parseIpAddr(String s) {
        int colon = s.indexOf(58);
        if (colon > 0 && colon < s.length()) {
            byte[] first = Builder.hexStringToByteArray(s.substring(0, colon));
            int i = 0;
            while (i + 3 < first.length) {
                byte tmp = first[i];
                first[i] = first[i + 3];
                first[i + 3] = tmp;
                tmp = first[i + 1];
                first[i + 1] = first[i + 2];
                first[i + 2] = tmp;
                i += 4;
            }
            int second = Builder.hexStringToInt(s.substring(colon + 1), 0);
            return Pair.of(first, second);
        }
        return Pair.of(new byte[0], 0);
    }

    private static Pair<Integer, Integer> parseHexColonHex(String s) {
        int colon = s.indexOf(58);
        if (colon > 0 && colon < s.length()) {
            int first = Builder.hexStringToInt(s.substring(0, colon), 0);
            int second = Builder.hexStringToInt(s.substring(colon + 1), 0);
            return Pair.of(first, second);
        }
        return Pair.of(0, 0);
    }

    private static InternetProtocolStats.TcpState stateLookup(int state) {
        switch (state) {
            case 1: {
                return InternetProtocolStats.TcpState.ESTABLISHED;
            }
            case 2: {
                return InternetProtocolStats.TcpState.SYN_SENT;
            }
            case 3: {
                return InternetProtocolStats.TcpState.SYN_RECV;
            }
            case 4: {
                return InternetProtocolStats.TcpState.FIN_WAIT_1;
            }
            case 5: {
                return InternetProtocolStats.TcpState.FIN_WAIT_2;
            }
            case 6: {
                return InternetProtocolStats.TcpState.TIME_WAIT;
            }
            case 7: {
                return InternetProtocolStats.TcpState.CLOSED;
            }
            case 8: {
                return InternetProtocolStats.TcpState.CLOSE_WAIT;
            }
            case 9: {
                return InternetProtocolStats.TcpState.LAST_ACK;
            }
            case 10: {
                return InternetProtocolStats.TcpState.LISTEN;
            }
            case 11: {
                return InternetProtocolStats.TcpState.CLOSING;
            }
        }
        return InternetProtocolStats.TcpState.UNKNOWN;
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        return NetStat.queryTcpStats("netstat -st4");
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        return NetStat.queryUdpStats("netstat -su4");
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        return NetStat.queryUdpStats("netstat -su6");
    }

    @Override
    public List<InternetProtocolStats.IPConnection> getConnections() {
        ArrayList<InternetProtocolStats.IPConnection> conns = new ArrayList<InternetProtocolStats.IPConnection>();
        Map<Integer, Integer> pidMap = ProcessStat.querySocketToPidMap();
        conns.addAll(LinuxInternetProtocolStats.queryConnections("tcp", 4, pidMap));
        conns.addAll(LinuxInternetProtocolStats.queryConnections("tcp", 6, pidMap));
        conns.addAll(LinuxInternetProtocolStats.queryConnections("udp", 4, pidMap));
        conns.addAll(LinuxInternetProtocolStats.queryConnections("udp", 6, pidMap));
        return conns;
    }
}

