/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.software;

import com.sun.jna.Native;
import com.sun.jna.platform.linux.LibC;
import com.sun.jna.ptr.PointerByReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractNetworkParams;
import org.aoju.bus.health.linux.LinuxLibc;
import org.aoju.bus.health.unix.CLibrary;
import org.aoju.bus.logger.Logger;

@ThreadSafe
final class LinuxNetworkParams
extends AbstractNetworkParams {
    private static final LinuxLibc LIBC = LinuxLibc.INSTANCE;
    private static final String IPV4_DEFAULT_DEST = "0.0.0.0";
    private static final String IPV6_DEFAULT_DEST = "::/0";

    LinuxNetworkParams() {
    }

    @Override
    public String getDomainName() {
        String hostname;
        CLibrary.Addrinfo hint = new CLibrary.Addrinfo();
        hint.ai_flags = 2;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            Logger.error("Unknown host exception when getting address of local host: {}", e.getMessage());
            return "";
        }
        PointerByReference ptr = new PointerByReference();
        int res = LIBC.getaddrinfo(hostname, null, hint, ptr);
        if (res > 0) {
            if (Logger.get().isError()) {
                Logger.error("Failed getaddrinfo(): {}", LIBC.gai_strerror(res));
            }
            return "";
        }
        CLibrary.Addrinfo info = new CLibrary.Addrinfo(ptr.getValue());
        String canonname = info.ai_canonname.trim();
        LIBC.freeaddrinfo(ptr.getValue());
        return canonname;
    }

    @Override
    public String getHostName() {
        byte[] hostnameBuffer = new byte[256];
        if (0 != LibC.INSTANCE.gethostname(hostnameBuffer, hostnameBuffer.length)) {
            return super.getHostName();
        }
        return Native.toString((byte[])hostnameBuffer);
    }

    @Override
    public String getIpv4DefaultGateway() {
        List<String> routes = Executor.runNative("route -A inet -n");
        if (routes.size() <= 2) {
            return "";
        }
        String gateway = "";
        int minMetric = Integer.MAX_VALUE;
        for (int i = 2; i < routes.size(); ++i) {
            String[] fields = RegEx.SPACES.split(routes.get(i));
            if (fields.length <= 4 || !fields[0].equals(IPV4_DEFAULT_DEST)) continue;
            boolean isGateway = fields[3].indexOf(71) != -1;
            int metric = Builder.parseIntOrDefault(fields[4], Integer.MAX_VALUE);
            if (!isGateway || metric >= minMetric) continue;
            minMetric = metric;
            gateway = fields[1];
        }
        return gateway;
    }

    @Override
    public String getIpv6DefaultGateway() {
        List<String> routes = Executor.runNative("route -A inet6 -n");
        if (routes.size() <= 2) {
            return "";
        }
        String gateway = "";
        int minMetric = Integer.MAX_VALUE;
        for (int i = 2; i < routes.size(); ++i) {
            String[] fields = RegEx.SPACES.split(routes.get(i));
            if (fields.length <= 3 || !fields[0].equals(IPV6_DEFAULT_DEST)) continue;
            boolean isGateway = fields[2].indexOf(71) != -1;
            int metric = Builder.parseIntOrDefault(fields[3], Integer.MAX_VALUE);
            if (!isGateway || metric >= minMetric) continue;
            minMetric = metric;
            gateway = fields[1];
        }
        return gateway;
    }
}

