/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.hardware;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.builtin.hardware.AbstractPowerSource;
import org.aoju.bus.health.builtin.hardware.PowerSource;
import org.aoju.bus.health.mac.drivers.WindowInfo;

@ThreadSafe
public final class MacPowerSource
extends AbstractPowerSource {
    private static final CoreFoundation CF = CoreFoundation.INSTANCE;
    private static final IOKit IO = IOKit.INSTANCE;

    public MacPowerSource(String psName, String psDeviceName, double psRemainingCapacityPercent, double psTimeRemainingEstimated, double psTimeRemainingInstant, double psPowerUsageRate, double psVoltage, double psAmperage, boolean psPowerOnLine, boolean psCharging, boolean psDischarging, PowerSource.CapacityUnits psCapacityUnits, int psCurrentCapacity, int psMaxCapacity, int psDesignCapacity, int psCycleCount, String psChemistry, LocalDate psManufactureDate, String psManufacturer, String psSerialNumber, double psTemperature) {
        super(psName, psDeviceName, psRemainingCapacityPercent, psTimeRemainingEstimated, psTimeRemainingInstant, psPowerUsageRate, psVoltage, psAmperage, psPowerOnLine, psCharging, psDischarging, psCapacityUnits, psCurrentCapacity, psMaxCapacity, psDesignCapacity, psCycleCount, psChemistry, psManufactureDate, psManufacturer, psSerialNumber, psTemperature);
    }

    public static List<PowerSource> getPowerSources() {
        String psDeviceName = "unknown";
        double psTimeRemainingInstant = 0.0;
        double psPowerUsageRate = 0.0;
        double psVoltage = -1.0;
        double psAmperage = 0.0;
        boolean psPowerOnLine = false;
        boolean psCharging = false;
        boolean psDischarging = false;
        PowerSource.CapacityUnits psCapacityUnits = PowerSource.CapacityUnits.RELATIVE;
        int psCurrentCapacity = 0;
        int psMaxCapacity = 1;
        int psDesignCapacity = 1;
        int psCycleCount = -1;
        String psChemistry = "unknown";
        LocalDate psManufactureDate = null;
        String psManufacturer = "unknown";
        String psSerialNumber = "unknown";
        double psTemperature = 0.0;
        IOKit.IOService smartBattery = IOKitUtil.getMatchingService((String)"AppleSmartBattery");
        if (null != smartBattery) {
            Integer temp;
            String s = smartBattery.getStringProperty("DeviceName");
            if (null != s) {
                psDeviceName = s;
            }
            if (null != (s = smartBattery.getStringProperty("Manufacturer"))) {
                psManufacturer = s;
            }
            if (null != (s = smartBattery.getStringProperty("BatterySerialNumber"))) {
                psSerialNumber = s;
            }
            if (null != (temp = smartBattery.getIntegerProperty("ManufactureDate"))) {
                int day = temp & 0x1F;
                int month = temp >> 5 & 0xF;
                int year80 = temp >> 9 & 0x7F;
                psManufactureDate = LocalDate.of(1980 + year80, month, day);
            }
            if (null != (temp = smartBattery.getIntegerProperty("DesignCapacity"))) {
                psDesignCapacity = temp;
            }
            if (null != (temp = smartBattery.getIntegerProperty("MaxCapacity"))) {
                psMaxCapacity = temp;
            }
            if (null != (temp = smartBattery.getIntegerProperty("CurrentCapacity"))) {
                psCurrentCapacity = temp;
            }
            psCapacityUnits = PowerSource.CapacityUnits.MAH;
            temp = smartBattery.getIntegerProperty("TimeRemaining");
            if (null != temp) {
                psTimeRemainingInstant = (double)temp.intValue() * 60.0;
            }
            if (null != (temp = smartBattery.getIntegerProperty("CycleCount"))) {
                psCycleCount = temp;
            }
            if (null != (temp = smartBattery.getIntegerProperty("Temperature"))) {
                psTemperature = (double)temp.intValue() / 100.0;
            }
            if (null != (temp = smartBattery.getIntegerProperty("Voltage"))) {
                psVoltage = (double)temp.intValue() / 1000.0;
            }
            if (null != (temp = smartBattery.getIntegerProperty("Amperage"))) {
                psAmperage = temp.intValue();
            }
            psPowerUsageRate = psVoltage * psAmperage;
            Boolean bool = smartBattery.getBooleanProperty("ExternalConnected");
            if (null != bool) {
                psPowerOnLine = bool;
            }
            if (null != (bool = smartBattery.getBooleanProperty("IsCharging"))) {
                psCharging = bool;
            }
            psDischarging = !psCharging;
            smartBattery.release();
        }
        CoreFoundation.CFTypeRef powerSourcesInfo = IO.IOPSCopyPowerSourcesInfo();
        CoreFoundation.CFArrayRef powerSourcesList = IO.IOPSCopyPowerSourcesList(powerSourcesInfo);
        int powerSourcesCount = powerSourcesList.getCount();
        double psTimeRemainingEstimated = IO.IOPSGetTimeRemainingEstimate();
        CoreFoundation.CFStringRef nameKey = CoreFoundation.CFStringRef.createCFString((String)"Name");
        CoreFoundation.CFStringRef isPresentKey = CoreFoundation.CFStringRef.createCFString((String)"Is Present");
        CoreFoundation.CFStringRef currentCapacityKey = CoreFoundation.CFStringRef.createCFString((String)"Current Capacity");
        CoreFoundation.CFStringRef maxCapacityKey = CoreFoundation.CFStringRef.createCFString((String)"Max Capacity");
        ArrayList<PowerSource> psList = new ArrayList<PowerSource>(powerSourcesCount);
        for (int ps = 0; ps < powerSourcesCount; ++ps) {
            CoreFoundation.CFBooleanRef isPresentRef;
            Pointer pwrSrcPtr = powerSourcesList.getValueAtIndex(ps);
            CoreFoundation.CFTypeRef powerSource = new CoreFoundation.CFTypeRef();
            powerSource.setPointer(pwrSrcPtr);
            CoreFoundation.CFDictionaryRef dictionary = IO.IOPSGetPowerSourceDescription(powerSourcesInfo, powerSource);
            Pointer result = dictionary.getValue((PointerType)isPresentKey);
            if (null == result || 0 == CF.CFBooleanGetValue(isPresentRef = new CoreFoundation.CFBooleanRef(result))) continue;
            result = dictionary.getValue((PointerType)nameKey);
            String psName = WindowInfo.cfPointerToString(result);
            double currentCapacity = 0.0;
            if (dictionary.getValueIfPresent((PointerType)currentCapacityKey, null)) {
                result = dictionary.getValue((PointerType)currentCapacityKey);
                CoreFoundation.CFNumberRef cap = new CoreFoundation.CFNumberRef(result);
                currentCapacity = cap.intValue();
            }
            double maxCapacity = 1.0;
            if (dictionary.getValueIfPresent((PointerType)maxCapacityKey, null)) {
                result = dictionary.getValue((PointerType)maxCapacityKey);
                CoreFoundation.CFNumberRef cap = new CoreFoundation.CFNumberRef(result);
                maxCapacity = cap.intValue();
            }
            double psRemainingCapacityPercent = Math.min(1.0, currentCapacity / maxCapacity);
            psList.add(new MacPowerSource(psName, psDeviceName, psRemainingCapacityPercent, psTimeRemainingEstimated, psTimeRemainingInstant, psPowerUsageRate, psVoltage, psAmperage, psPowerOnLine, psCharging, psDischarging, psCapacityUnits, psCurrentCapacity, psMaxCapacity, psDesignCapacity, psCycleCount, psChemistry, psManufactureDate, psManufacturer, psSerialNumber, psTemperature));
        }
        isPresentKey.release();
        nameKey.release();
        currentCapacityKey.release();
        maxCapacityKey.release();
        powerSourcesList.release();
        powerSourcesInfo.release();
        return psList;
    }
}

