/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.drivers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.hardware.HWPartition;
import org.aoju.bus.health.unix.freebsd.drivers.Mount;

@ThreadSafe
public final class GeomPartList {
    private static final String GEOM_PART_LIST = "geom part list";
    private static final String STAT_FILESIZE = "stat -f %i /dev/";

    private GeomPartList() {
    }

    public static Map<String, List<HWPartition>> queryPartitions() {
        Map<String, String> mountMap = Mount.queryPartitionToMountMap();
        HashMap<String, List<HWPartition>> partitionMap = new HashMap<String, List<HWPartition>>();
        String diskName = null;
        List<Object> partList = new ArrayList();
        String partName = null;
        String identification = "unknown";
        String type = "unknown";
        String uuid = "unknown";
        long size = 0L;
        String mountPoint = "";
        List<String> geom = Executor.runNative(GEOM_PART_LIST);
        for (String line : geom) {
            String[] split;
            if ((line = line.trim()).startsWith("Geom name:")) {
                if (null != diskName && !partList.isEmpty()) {
                    partitionMap.put(diskName, partList);
                    partList = new ArrayList();
                }
                diskName = line.substring(line.lastIndexOf(32) + 1);
            }
            if (null == diskName) continue;
            if (line.contains("Name:")) {
                String part;
                if (null != partName) {
                    int minor = Builder.parseIntOrDefault(Executor.getFirstAnswer(STAT_FILESIZE + partName), 0);
                    partList.add(new HWPartition(identification, partName, type, uuid, size, 0, minor, mountPoint));
                    partName = null;
                    identification = "unknown";
                    type = "unknown";
                    uuid = "unknown";
                    size = 0L;
                }
                if ((part = line.substring(line.lastIndexOf(32) + 1)).startsWith(diskName)) {
                    partName = part;
                    identification = part;
                    mountPoint = mountMap.getOrDefault(part, "");
                }
            }
            if (null == partName || (split = RegEx.SPACES.split(line)).length < 2) continue;
            if (line.startsWith("Mediasize:")) {
                size = Builder.parseLongOrDefault(split[1], 0L);
                continue;
            }
            if (line.startsWith("rawuuid:")) {
                uuid = split[1];
                continue;
            }
            if (!line.startsWith("type:")) continue;
            type = split[1];
        }
        if (null != diskName) {
            if (null != partName) {
                int minor = Builder.parseIntOrDefault(Executor.getFirstAnswer(STAT_FILESIZE + partName), 0);
                partList.add(new HWPartition(identification, partName, type, uuid, size, 0, minor, mountPoint));
            }
            if (!partList.isEmpty()) {
                partList = partList.stream().sorted(Comparator.comparing(HWPartition::getName)).collect(Collectors.toList());
                partitionMap.put(diskName, partList);
            }
        }
        return partitionMap;
    }
}

