/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.hardware;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.hardware.AbstractCentralProcessor;
import org.aoju.bus.health.builtin.hardware.CentralProcessor;
import org.aoju.bus.health.unix.solaris.KstatKit;
import org.aoju.bus.health.unix.solaris.SolarisLibc;

@ThreadSafe
final class SolarisCentralProcessor
extends AbstractCentralProcessor {
    private static final String CPU_INFO = "cpu_info";

    SolarisCentralProcessor() {
    }

    private static Map<Integer, Integer> mapNumaNodes() {
        HashMap<Integer, Integer> numaNodeMap = new HashMap<Integer, Integer>();
        int lgroup = 0;
        for (String line : Executor.runNative("lgrpinfo -c leaves")) {
            if (line.startsWith("lgroup")) {
                lgroup = Builder.getFirstIntValue(line);
                continue;
            }
            if (!line.contains("CPUs:") && !line.contains("CPU:")) continue;
            for (Integer cpu : Builder.parseHyphenatedIntList(line.split(":")[1])) {
                numaNodeMap.put(cpu, lgroup);
            }
        }
        return numaNodeMap;
    }

    private static String getProcessorID(String stepping, String model, String family) {
        List<String> isainfo = Executor.runNative("isainfo -v");
        StringBuilder flags = new StringBuilder();
        for (String line : isainfo) {
            if (line.startsWith("32-bit")) break;
            if (line.startsWith("64-bit")) continue;
            flags.append(' ').append(line.trim());
        }
        return SolarisCentralProcessor.createProcessorID(stepping, model, family, RegEx.SPACES.split(flags.toString().toLowerCase()));
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String cpuVendor = "";
        String cpuName = "";
        String cpuFamily = "";
        String cpuModel = "";
        String cpuStepping = "";
        long cpuFreq = 0L;
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            LibKstat.Kstat ksp = KstatKit.KstatChain.lookup(CPU_INFO, -1, null);
            if (null != ksp && KstatKit.KstatChain.read(ksp)) {
                cpuVendor = KstatKit.dataLookupString(ksp, "vendor_id");
                cpuName = KstatKit.dataLookupString(ksp, "brand");
                cpuFamily = KstatKit.dataLookupString(ksp, "family");
                cpuModel = KstatKit.dataLookupString(ksp, "model");
                cpuStepping = KstatKit.dataLookupString(ksp, "stepping");
                cpuFreq = KstatKit.dataLookupLong(ksp, "clock_MHz") * 1000000L;
            }
        }
        boolean cpu64bit = "64".equals(Executor.getFirstAnswer("isainfo -b").trim());
        String processorID = SolarisCentralProcessor.getProcessorID(cpuStepping, cpuModel, cpuFamily);
        return new CentralProcessor.ProcessorIdentifier(cpuVendor, cpuName, cpuFamily, cpuModel, cpuStepping, processorID, cpu64bit, cpuFreq);
    }

    @Override
    protected List<CentralProcessor.LogicalProcessor> initProcessorCounts() {
        Map<Integer, Integer> numaNodeMap = SolarisCentralProcessor.mapNumaNodes();
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            List<LibKstat.Kstat> kstats = KstatKit.KstatChain.lookupAll(CPU_INFO, -1, null);
            for (LibKstat.Kstat ksp : kstats) {
                if (null == ksp || !KstatKit.KstatChain.read(ksp)) continue;
                int procId = logProcs.size();
                String chipId = KstatKit.dataLookupString(ksp, "chip_id");
                String coreId = KstatKit.dataLookupString(ksp, "core_id");
                CentralProcessor.LogicalProcessor logProc = new CentralProcessor.LogicalProcessor(procId, Builder.parseIntOrDefault(coreId, 0), Builder.parseIntOrDefault(chipId, 0), numaNodeMap.getOrDefault(procId, 0));
                logProcs.add(logProc);
            }
        }
        if (logProcs.isEmpty()) {
            logProcs.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
        }
        return logProcs;
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        long[][] procTicks = this.getProcessorCpuLoadTicks();
        int i = 0;
        while (i < ticks.length) {
            for (long[] procTick : procTicks) {
                int n = i;
                ticks[n] = ticks[n] + procTick[i];
            }
            int n = i++;
            ticks[n] = ticks[n] / (long)procTicks.length;
        }
        return ticks;
    }

    @Override
    public long[] queryCurrentFreq() {
        long[] freqs = new long[this.getLogicalProcessorCount()];
        Arrays.fill(freqs, -1L);
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            for (int i = 0; i < freqs.length; ++i) {
                for (LibKstat.Kstat ksp : KstatKit.KstatChain.lookupAll(CPU_INFO, i, null)) {
                    if (!KstatKit.KstatChain.read(ksp)) continue;
                    freqs[i] = KstatKit.dataLookupLong(ksp, "current_clock_Hz");
                }
            }
        }
        return freqs;
    }

    @Override
    public long queryMaxFreq() {
        long max = -1L;
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            for (LibKstat.Kstat ksp : KstatKit.KstatChain.lookupAll(CPU_INFO, 0, null)) {
                String suppFreq;
                if (!KstatKit.KstatChain.read(ksp) || (suppFreq = KstatKit.dataLookupString(ksp, "supported_frequencies_Hz")).isEmpty()) continue;
                for (String s : suppFreq.split(":")) {
                    long freq = Builder.parseLongOrDefault(s, -1L);
                    if (max >= freq) continue;
                    max = freq;
                }
            }
        }
        return max;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = SolarisLibc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int cpu = -1;
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            for (LibKstat.Kstat ksp : KstatKit.KstatChain.lookupAll("cpu", -1, "sys")) {
                if (++cpu >= ticks.length) {
                    break;
                }
                if (!KstatKit.KstatChain.read(ksp)) continue;
                ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = KstatKit.dataLookupLong(ksp, "cpu_ticks_idle");
                ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = KstatKit.dataLookupLong(ksp, "cpu_ticks_kernel");
                ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = KstatKit.dataLookupLong(ksp, "cpu_ticks_user");
            }
        }
        return ticks;
    }

    @Override
    public long queryContextSwitches() {
        long swtch = 0L;
        List<String> kstat = Executor.runNative("kstat -p cpu_stat:::/pswitch\\\\|inv_swtch/");
        for (String s : kstat) {
            swtch += Builder.parseLastLong(s, 0L);
        }
        return swtch;
    }

    @Override
    public long queryInterrupts() {
        long intr = 0L;
        List<String> kstat = Executor.runNative("kstat -p cpu_stat:::/intr/");
        for (String s : kstat) {
            intr += Builder.parseLastLong(s, 0L);
        }
        return intr;
    }
}

