/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.software;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractOSThread;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.unix.solaris.software.SolarisOSProcess;

@ThreadSafe
public class SolarisOSThread
extends AbstractOSThread {
    private int threadId;
    private OSProcess.State state = OSProcess.State.INVALID;
    private long startMemoryAddress;
    private long contextSwitches;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private int priority;

    public SolarisOSThread(int pid, String[] split) {
        super(pid);
        this.updateAttributes(split);
    }

    @Override
    public int getThreadId() {
        return this.threadId;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public long getStartMemoryAddress() {
        return this.startMemoryAddress;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean updateAttributes() {
        Optional<String[]> split;
        List<String> threadListInfo2;
        List<String> threadListInfo1 = Executor.runNative("ps -o lwp,s,etime,stime,time,addr,pri -p " + this.getOwningProcessId());
        Map<Integer, String[]> threadMap = SolarisOSProcess.parseAndMergePSandPrstatInfo(threadListInfo1, 0, 7, threadListInfo2 = Executor.runNative("prstat -L -v -p " + this.getOwningProcessId() + " 1 1"), true);
        if (threadMap.keySet().size() > 1 && (split = threadMap.entrySet().stream().filter(entry -> ((Integer)entry.getKey()).intValue() == this.getThreadId()).map(Map.Entry::getValue).findFirst()).isPresent()) {
            return this.updateAttributes(split.get());
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    private boolean updateAttributes(String[] split) {
        this.threadId = Builder.parseIntOrDefault(split[0], 0);
        this.state = SolarisOSProcess.getStateFromOutput(split[1].charAt(0));
        long elapsedTime = Builder.parseDHMSOrDefault(split[2], 0L);
        this.upTime = elapsedTime < 1L ? 1L : elapsedTime;
        long now = System.currentTimeMillis();
        this.startTime = now - this.upTime;
        this.kernelTime = Builder.parseDHMSOrDefault(split[3], 0L);
        this.userTime = Builder.parseDHMSOrDefault(split[4], 0L) - this.kernelTime;
        this.startMemoryAddress = Builder.hexStringToLong(split[5], 0L);
        this.priority = Builder.parseIntOrDefault(split[6], 0);
        long nonVoluntaryContextSwitches = Builder.parseLongOrDefault(split[7], 0L);
        long voluntaryContextSwitches = Builder.parseLongOrDefault(split[8], 0L);
        this.contextSwitches = voluntaryContextSwitches + nonVoluntaryContextSwitches;
        return true;
    }
}

