/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.software;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractOperatingSystem;
import org.aoju.bus.health.builtin.software.FileSystem;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;
import org.aoju.bus.health.builtin.software.NetworkParams;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.builtin.software.OSService;
import org.aoju.bus.health.builtin.software.OSSession;
import org.aoju.bus.health.builtin.software.OperatingSystem;
import org.aoju.bus.health.linux.drivers.ProcessStat;
import org.aoju.bus.health.unix.solaris.KstatKit;
import org.aoju.bus.health.unix.solaris.SolarisLibc;
import org.aoju.bus.health.unix.solaris.drivers.Who;
import org.aoju.bus.health.unix.solaris.software.SolarisFileSystem;
import org.aoju.bus.health.unix.solaris.software.SolarisInternetProtocolStats;
import org.aoju.bus.health.unix.solaris.software.SolarisNetworkParams;
import org.aoju.bus.health.unix.solaris.software.SolarisOSProcess;

@ThreadSafe
public class SolarisOperatingSystem
extends AbstractOperatingSystem {
    private static final String PS_FIELDS = "s,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etime,time,comm,args";
    private static final String PROCESS_LIST_FOR_PID_COMMAND = "ps -o s,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etime,time,comm,args -p ";
    private static final String PROCESS_LIST_COMMAND = "ps -eo s,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etime,time,comm,args";
    private static final long BOOTTIME = SolarisOperatingSystem.querySystemBootTime();

    private static long querySystemUptime() {
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            LibKstat.Kstat ksp = KstatKit.KstatChain.lookup("unix", 0, "system_misc");
            if (null != ksp) {
                long l = ksp.ks_snaptime / 1000000000L;
                return l;
            }
        }
        return 0L;
    }

    private static List<OSProcess> queryAllProcessesFromPS() {
        return SolarisOperatingSystem.getProcessListFromPS(PROCESS_LIST_COMMAND, -1);
    }

    private static List<OSProcess> getProcessListFromPS(String psCommand, int pid) {
        List<String> procList = pid < 0 ? Executor.runNative(psCommand) : Executor.runNative(psCommand + pid);
        List<String> procList2 = pid < 0 ? Executor.runNative("prstat -v 1 1") : Executor.runNative("prstat -v -p " + pid + " 1 1");
        Map<Integer, String[]> processMap = SolarisOSProcess.parseAndMergePSandPrstatInfo(procList, 1, 15, procList2, false);
        return processMap.entrySet().stream().map(e -> new SolarisOSProcess((Integer)e.getKey(), (String[])e.getValue())).collect(Collectors.toList());
    }

    private static long querySystemBootTime() {
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            LibKstat.Kstat ksp = KstatKit.KstatChain.lookup("unix", 0, "system_misc");
            if (null != ksp && KstatKit.KstatChain.read(ksp)) {
                long l = KstatKit.dataLookupLong(ksp, "boot_time");
                return l;
            }
        }
        return System.currentTimeMillis() / 1000L - SolarisOperatingSystem.querySystemUptime();
    }

    private static void addChildrenToDescendantSet(String parentPid, Set<String> descendantPids, boolean recurse) {
        HashSet<String> childPids = new HashSet<String>();
        for (String s : Executor.runNative("pgrep -P " + parentPid)) {
            String pid = s.trim();
            if (pid.equals(parentPid) || descendantPids.contains(pid)) continue;
            childPids.add(pid);
        }
        descendantPids.addAll(childPids);
        if (recurse) {
            for (String pid : childPids) {
                SolarisOperatingSystem.addChildrenToDescendantSet(pid, descendantPids, true);
            }
        }
    }

    @Override
    public String queryManufacturer() {
        return "Oracle";
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        String[] split = RegEx.SPACES.split(Executor.getFirstAnswer("uname -rv"));
        String version = split[0];
        String buildNumber = null;
        if (split.length > 1) {
            buildNumber = split[1];
        }
        return Pair.of("SunOS", new OperatingSystem.OSVersionInfo(version, "Solaris", buildNumber));
    }

    @Override
    protected int queryBitness(int jvmBitness) {
        if (jvmBitness == 64) {
            return 64;
        }
        return Builder.parseIntOrDefault(Executor.getFirstAnswer("isainfo -b"), 32);
    }

    @Override
    public FileSystem getFileSystem() {
        return new SolarisFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new SolarisInternetProtocolStats();
    }

    @Override
    public List<OSSession> getSessions() {
        return USE_WHO_COMMAND ? super.getSessions() : Who.queryUtxent();
    }

    @Override
    public int getProcessId() {
        return SolarisLibc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return ProcessStat.getPidFiles().length;
    }

    @Override
    public int getThreadCount() {
        List<String> threadList = Executor.runNative("ps -eLo pid");
        if (!threadList.isEmpty()) {
            return threadList.size() - 1;
        }
        return this.getProcessCount();
    }

    @Override
    public long getSystemUptime() {
        return SolarisOperatingSystem.querySystemUptime();
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new SolarisNetworkParams();
    }

    @Override
    public OSService[] getServices() {
        File[] listFiles;
        ArrayList<OSService> services = new ArrayList<OSService>();
        ArrayList<String> legacySvcs = new ArrayList<String>();
        File dir = new File("/etc/init.d");
        if (dir.exists() && dir.isDirectory() && null != (listFiles = dir.listFiles())) {
            for (File f : listFiles) {
                legacySvcs.add(f.getName());
            }
        }
        List<String> svcs = Executor.runNative("svcs -p");
        block1: for (String line : svcs) {
            if (line.startsWith("online")) {
                int delim = line.lastIndexOf(":/");
                if (delim <= 0) continue;
                String name = line.substring(delim + 1);
                if (name.endsWith(":default")) {
                    name = name.substring(0, name.length() - 8);
                }
                services.add(new OSService(name, 0, OSService.State.STOPPED));
                continue;
            }
            if (line.startsWith(" ")) {
                String[] split = RegEx.SPACES.split(line.trim());
                if (split.length != 3) continue;
                services.add(new OSService(split[2], Builder.parseIntOrDefault(split[1], 0), OSService.State.RUNNING));
                continue;
            }
            if (!line.startsWith("legacy_run")) continue;
            for (String svc : legacySvcs) {
                if (!line.endsWith(svc)) continue;
                services.add(new OSService(svc, 0, OSService.State.STOPPED));
                continue block1;
            }
        }
        return services.toArray(new OSService[0]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        List<OSProcess> procs = SolarisOperatingSystem.getProcessListFromPS(PROCESS_LIST_FOR_PID_COMMAND, pid);
        if (procs.isEmpty()) {
            return null;
        }
        return procs.get(0);
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return SolarisOperatingSystem.queryAllProcessesFromPS();
    }

    @Override
    public List<OSProcess> queryChildProcesses(int parentPid) {
        List<OSProcess> allProcs = SolarisOperatingSystem.queryAllProcessesFromPS();
        Set<Integer> descendantPids = SolarisOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, false);
        return allProcs.stream().filter(p -> descendantPids.contains(p.getProcessID())).collect(Collectors.toList());
    }

    @Override
    public List<OSProcess> queryDescendantProcesses(int parentPid) {
        List<OSProcess> allProcs = SolarisOperatingSystem.queryAllProcessesFromPS();
        Set<Integer> descendantPids = SolarisOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, true);
        return allProcs.stream().filter(p -> descendantPids.contains(p.getProcessID())).collect(Collectors.toList());
    }
}

