/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.bodys;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.aoju.bus.core.io.ByteString;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.OnBack;
import org.aoju.bus.http.Process;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.Results;
import org.aoju.bus.http.accord.ProcessStream;
import org.aoju.bus.http.bodys.AbstractBody;
import org.aoju.bus.http.bodys.ResponseBody;
import org.aoju.bus.http.metric.Download;
import org.aoju.bus.http.metric.TaskExecutor;
import org.aoju.bus.http.metric.http.CoverHttp;

public class ResultBody
extends AbstractBody
implements Results.Body {
    private final Response response;
    private boolean onIO = false;
    private OnBack<Process> onProcess;
    private long stepBytes = 0L;
    private double stepRate = -1.0;
    private boolean rangeIgnored = false;
    private CoverHttp<?> coverHttp;
    private boolean cached = false;
    private byte[] data;

    public ResultBody(CoverHttp<?> coverHttp, Response response, TaskExecutor taskExecutor) {
        super(taskExecutor, coverHttp.charset(response));
        this.coverHttp = coverHttp;
        this.response = response;
    }

    @Override
    public MediaType getType() {
        ResponseBody body = this.response.body();
        if (null != body) {
            return body.contentType();
        }
        return null;
    }

    @Override
    public long getLength() {
        ResponseBody body = this.response.body();
        if (null != body) {
            return body.contentLength();
        }
        return 0L;
    }

    @Override
    public Results.Body nextOnIO() {
        this.onIO = true;
        return this;
    }

    @Override
    public Results.Body setOnProcess(OnBack<Process> onProcess) {
        if (null == this.taskExecutor) {
            throw new IllegalStateException("Task executor is null!");
        }
        if (this.cached) {
            throw new IllegalStateException("After the cache is turned on, you cannot set a download progress callback!");
        }
        this.onProcess = onProcess;
        return this;
    }

    @Override
    public Results.Body stepBytes(long stepBytes) {
        this.stepBytes = stepBytes;
        return this;
    }

    @Override
    public Results.Body stepRate(double stepRate) {
        this.stepRate = stepRate;
        return this;
    }

    @Override
    public Results.Body setRangeIgnored() {
        this.rangeIgnored = true;
        return this;
    }

    @Override
    public InputStream toByteStream() {
        ResponseBody body;
        InputStream input = this.cached ? new ByteArrayInputStream(this.cacheBytes()) : (null != (body = this.response.body()) ? body.byteStream() : new ByteArrayInputStream(new byte[0]));
        if (null != this.onProcess) {
            long rangeStart = this.getRangeStart();
            long totalBytes = this.getLength();
            if (!this.rangeIgnored) {
                totalBytes += rangeStart;
            }
            if (this.stepRate > 0.0 && this.stepRate <= 1.0) {
                this.stepBytes = (long)((double)totalBytes * this.stepRate);
            }
            if (this.stepBytes <= 0L) {
                this.stepBytes = 8192L;
            }
            return new ProcessStream(input, this.onProcess, totalBytes, this.stepBytes, this.rangeIgnored ? 0L : rangeStart, this.taskExecutor.getExecutor(this.onIO));
        }
        return input;
    }

    @Override
    public byte[] toBytes() {
        if (this.cached) {
            return this.cacheBytes();
        }
        return this.bodyToBytes();
    }

    @Override
    public Reader toCharStream() {
        if (this.cached || null != this.onProcess) {
            return new InputStreamReader(this.toByteStream());
        }
        ResponseBody body = this.response.body();
        if (null != body) {
            return body.charStream();
        }
        return new CharArrayReader(new char[0]);
    }

    @Override
    public String toString() {
        if (this.cached || null != this.onProcess) {
            return new String(this.toBytes(), this.charset);
        }
        try {
            ResponseBody body = this.response.body();
            if (null != body) {
                return new String(body.bytes(), this.charset);
            }
        }
        catch (IOException e) {
            throw new InstrumentException("Error in converting the body of the message!", e);
        }
        return null;
    }

    @Override
    public ByteString toByteString() {
        return ByteString.of(this.toBytes());
    }

    @Override
    public Download toFile(String filePath) {
        return this.toFile(new File(filePath));
    }

    @Override
    public Download toFile(File file) {
        if (null == this.taskExecutor) {
            throw new IllegalStateException("Task executor is null!");
        }
        if (!file.exists()) {
            try {
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                file.createNewFile();
            }
            catch (IOException e) {
                this.response.close();
                throw new InstrumentException("Cannot create file [" + file.getAbsolutePath() + "]", e);
            }
        }
        return this.taskExecutor.download(this.coverHttp, file, this.toByteStream(), this.getRangeStart());
    }

    @Override
    public Download toFolder(String dirPath) {
        String fileName = this.resolveFileName();
        String filePath = this.resolveFilePath(dirPath, fileName);
        int index = 0;
        File file = new File(filePath);
        while (file.exists()) {
            String indexFileName = this.indexFileName(fileName, index++);
            filePath = this.resolveFilePath(dirPath, indexFileName);
            file = new File(filePath);
        }
        return this.toFile(file);
    }

    @Override
    public Download toFolder(File dir) {
        if (dir.exists() && !dir.isDirectory()) {
            this.response.close();
            throw new InstrumentException("File download failed\uff1a[" + dir.getAbsolutePath() + "] Already exists and is not a directory !");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return this.toFolder(dir.getAbsolutePath());
    }

    @Override
    public Results.Body cache() {
        if (null != this.onProcess) {
            throw new IllegalStateException("After the cache is turned on, you cannot set a download progress callback!");
        }
        this.cached = true;
        return this;
    }

    @Override
    public Results.Body close() {
        this.response.close();
        this.data = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] cacheBytes() {
        Response response = this.response;
        synchronized (response) {
            if (null == this.data) {
                this.data = this.bodyToBytes();
            }
        }
        return this.data;
    }

    /*
     * Exception decompiling
     */
    private byte[] bodyToBytes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long getRangeStart() {
        int index;
        long rangeStart = 0L;
        if (this.response.code() != 206) {
            return rangeStart;
        }
        String range = this.response.header("Content-Range");
        if (null != range && range.startsWith("bytes") && (index = range.indexOf(45)) > 5) {
            String start = range.substring(5, index).trim();
            try {
                rangeStart = Long.parseLong(start);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rangeStart;
    }

    private String resolveFilePath(String dirPath, String fileName) {
        if (dirPath.endsWith("\\") || dirPath.endsWith("/")) {
            return dirPath + fileName;
        }
        return dirPath + "\\" + fileName;
    }

    private String indexFileName(String fileName, int index) {
        int i = fileName.lastIndexOf(46);
        if (i < 0) {
            return fileName + "(" + index + ")";
        }
        String ext = fileName.substring(i);
        if (i > 0) {
            String name = fileName.substring(0, i);
            return name + "(" + index + ")" + ext;
        }
        return "(" + index + ")" + ext;
    }

    private String resolveFileName() {
        String fileName = this.response.header("Content-Disposition");
        if (null == fileName || fileName.length() < 1) {
            fileName = this.response.request().url().encodedPath();
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        } else {
            try {
                fileName = URLDecoder.decode(fileName.substring(fileName.indexOf("filename=") + 9), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new InstrumentException("Failed to decode file name", e);
            }
            fileName = fileName.replaceAll("\"", "");
        }
        return fileName;
    }
}

