/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.magic;

import java.util.LinkedHashMap;
import java.util.Map;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.magic.RequestCall;

public abstract class RequestBuilder<T extends RequestBuilder> {
    protected Httpd httpd;
    protected String url;
    protected Object tag;
    protected Map<String, String> headers;
    protected Map<String, String> params;
    protected Map<String, String> encodedParams;
    protected int id;

    public RequestBuilder(Httpd httpd) {
        this.httpd = httpd;
        this.headers = new LinkedHashMap<String, String>();
        this.params = new LinkedHashMap<String, String>();
        this.encodedParams = new LinkedHashMap<String, String>();
    }

    public T id(int id) {
        this.id = id;
        return (T)this;
    }

    public T url(String url) {
        this.url = url;
        return (T)this;
    }

    public T tag(Object tag) {
        this.tag = tag;
        return (T)this;
    }

    public T headers(Map<String, String> headers) {
        this.headers = headers;
        return (T)this;
    }

    public T addHeaders(Map<String, String> headers) {
        if (null != headers) {
            headers.forEach((k, v) -> this.headers.put((String)k, (String)v));
        }
        return (T)this;
    }

    public T addHeader(String key, String val) {
        this.headers.put(key, val);
        return (T)this;
    }

    public T params(Map<String, String> params) {
        this.params = params;
        return (T)this;
    }

    public T addParams(String key, String val) {
        this.params.put(key, val);
        return (T)this;
    }

    public T addParams(Map<String, String> paramMap) {
        if (null == paramMap) {
            return (T)this;
        }
        paramMap.forEach((k, v) -> this.params.put((String)k, (String)v));
        return (T)this;
    }

    public T addParams(Object obj) {
        if (null != obj) {
            Map<String, Object> map = ClassKit.beanToMap(obj);
            map.forEach((key, val) -> this.addParams((String)key, (String)val));
        }
        return (T)this;
    }

    public T encodedParams(Map<String, String> params) {
        this.encodedParams = params;
        return (T)this;
    }

    public T addEncodedParams(String key, String val) {
        this.encodedParams.put(key, val);
        return (T)this;
    }

    public abstract RequestCall build();
}

