/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy;

import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;

public abstract class ConfigurationCache<C, T> {
    private final Map<String, CacheEntry<T>> cache = new HashMap<String, CacheEntry<T>>();
    private final C conf;
    private long staleTimeout;

    public ConfigurationCache(C conf) {
        if (null == conf) {
            throw new NullPointerException();
        }
        this.conf = conf;
    }

    public int getStaleTimeout() {
        return (int)(this.staleTimeout / 1000L);
    }

    public void setStaleTimeout(int staleTimeout) {
        this.staleTimeout = (long)staleTimeout * 1000L;
    }

    public void clear() {
        this.cache.clear();
    }

    public T get(String key) throws InstrumentException {
        long now = System.currentTimeMillis();
        CacheEntry<Object> entry = this.cache.get(key);
        if (null == entry || this.staleTimeout != 0L && now > entry.fetchTime + this.staleTimeout) {
            Object value = null;
            try {
                value = this.find(this.conf, key);
            }
            catch (InstrumentException instrumentException) {
                // empty catch block
            }
            entry = new CacheEntry<Object>(value, now);
            this.cache.put(key, entry);
        }
        return entry.value;
    }

    protected abstract T find(C var1, String var2) throws InstrumentException;

    private static final class CacheEntry<T> {
        final T value;
        final long fetchTime;

        CacheEntry(T value, long fetchTime) {
            this.value = value;
            this.fetchTime = fetchTime;
        }
    }
}

