/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import java.io.IOException;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.DimseRQHandler;
import org.aoju.bus.image.metric.IdentityNegotiator;
import org.aoju.bus.image.metric.internal.pdu.AAssociateAC;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRJ;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQ;
import org.aoju.bus.image.metric.internal.pdu.IdentityAC;
import org.aoju.bus.image.metric.internal.pdu.Presentation;

public class AssociationHandler {
    private IdentityNegotiator userIdNegotiator;

    public IdentityNegotiator getUserIdNegotiator() {
        return this.userIdNegotiator;
    }

    public void setUserIdNegotiator(IdentityNegotiator userIdNegotiator) {
        this.userIdNegotiator = userIdNegotiator;
    }

    protected AAssociateAC negotiate(Association as, AAssociateRQ rq) throws IOException {
        IdentityAC userIdentity;
        if ((rq.getProtocolVersion() & 1) == 0) {
            throw new AAssociateRJ(1, 2, 2);
        }
        if (!rq.getApplicationContext().equals("1.2.840.10008.3.1.1.1")) {
            throw new AAssociateRJ(1, 1, 2);
        }
        ApplicationEntity ae = as.getApplicationEntity();
        if (!(null != ae && ae.getConnections().contains(as.getConnection()) && ae.isInstalled() && ae.isAssociationAcceptor())) {
            throw new AAssociateRJ(1, 1, 7);
        }
        if (!ae.isAcceptedCallingAETitle(rq.getCallingAET())) {
            throw new AAssociateRJ(1, 1, 3);
        }
        IdentityAC identityAC = userIdentity = null != this.getUserIdNegotiator() ? this.getUserIdNegotiator().negotiate(as, rq.getIdentityRQ()) : null;
        if (ae.getDevice().isLimitOfAssociationsExceeded(rq)) {
            throw new AAssociateRJ(2, 3, 2);
        }
        return this.makeAAssociateAC(as, rq, userIdentity);
    }

    protected AAssociateAC makeAAssociateAC(Association as, AAssociateRQ rq, IdentityAC userIdentity) {
        AAssociateAC ac = new AAssociateAC();
        ac.setCalledAET(rq.getCalledAET());
        ac.setCallingAET(rq.getCallingAET());
        Connection conn = as.getConnection();
        ac.setMaxPDULength(conn.getReceivePDULength());
        ac.setMaxOpsInvoked(Association.minZeroAsMax(rq.getMaxOpsInvoked(), conn.getMaxOpsPerformed()));
        ac.setMaxOpsPerformed(Association.minZeroAsMax(rq.getMaxOpsPerformed(), conn.getMaxOpsInvoked()));
        ac.setIdentityAC(userIdentity);
        ApplicationEntity ae = as.getApplicationEntity();
        for (Presentation rqpc : rq.getPresentationContexts()) {
            ac.addPresentationContext(ae.negotiate(rq, ac, rqpc));
        }
        return ac;
    }

    protected void onClose(Association as) {
        DimseRQHandler tmp = as.getApplicationEntity().getDimseRQHandler();
        if (null != tmp) {
            tmp.onClose(as);
        }
    }
}

