/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.criteria;

import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.mapper.criteria.Assert;
import org.aoju.bus.mapper.entity.Condition;
import org.aoju.bus.mapper.entity.EntityColumn;

public class OrderBy {
    protected Map<String, EntityColumn> propertyMap;
    private Condition condition;
    private Boolean isProperty;

    public OrderBy(Condition condition, Map<String, EntityColumn> propertyMap) {
        this.condition = condition;
        this.propertyMap = propertyMap;
    }

    private String property(String property) {
        if (Assert.isEmpty(property) || Assert.isEmpty(property.trim())) {
            throw new InstrumentException("\u63a5\u6536\u7684property\u4e3a\u7a7a\uff01");
        }
        if (!this.propertyMap.containsKey(property = property.trim())) {
            throw new InstrumentException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
        }
        return this.propertyMap.get(property).getColumn();
    }

    public OrderBy orderBy(String property) {
        String column = this.property(property);
        if (null == column) {
            this.isProperty = false;
            return this;
        }
        if (Assert.isNotEmpty(this.condition.getOrderByClause())) {
            this.condition.setOrderByClause(this.condition.getOrderByClause() + "," + column);
        } else {
            this.condition.setOrderByClause(column);
        }
        this.isProperty = true;
        return this;
    }

    public OrderBy desc() {
        if (this.isProperty.booleanValue()) {
            this.condition.setOrderByClause(this.condition.getOrderByClause() + " DESC");
            this.isProperty = false;
        }
        return this;
    }

    public OrderBy asc() {
        if (this.isProperty.booleanValue()) {
            this.condition.setOrderByClause(this.condition.getOrderByClause() + " ASC");
            this.isProperty = false;
        }
        return this;
    }
}

