/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.reflection;

import org.aoju.bus.core.lang.exception.InstrumentException;
import org.apache.ibatis.mapping.MappedStatement;

public class Reflector {
    public static Class<?> getMapperClass(String msId) {
        if (msId.indexOf(".") == -1) {
            throw new InstrumentException("\u5f53\u524dMappedStatement\u7684id=" + msId + ",\u4e0d\u7b26\u5408MappedStatement\u7684\u89c4\u5219!");
        }
        String mapperClassStr = msId.substring(0, msId.lastIndexOf("."));
        ClassLoader[] classLoader = Reflector.getClassLoaders();
        Class<?> mapperClass = null;
        for (ClassLoader cl : classLoader) {
            if (null == cl) continue;
            try {
                mapperClass = Class.forName(mapperClassStr, true, cl);
                if (null == mapperClass) continue;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (null == mapperClass) {
            throw new InstrumentException("class loaders failed to locate the class " + mapperClassStr);
        }
        return mapperClass;
    }

    private static ClassLoader[] getClassLoaders() {
        return new ClassLoader[]{Thread.currentThread().getContextClassLoader(), Reflector.class.getClassLoader()};
    }

    public static String getMethodName(MappedStatement ms) {
        return Reflector.getMethodName(ms.getId());
    }

    public static String getMethodName(String msId) {
        return msId.substring(msId.lastIndexOf(".") + 1);
    }
}

