/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel.reader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.IterKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.reader.AbstractSheetReader;
import org.apache.poi.ss.usermodel.Sheet;

public class MapSheetReader
extends AbstractSheetReader<List<Map<String, Object>>> {
    private final int headerRowIndex;

    public MapSheetReader(int headerRowIndex, int startRowIndex, int endRowIndex) {
        super(startRowIndex, endRowIndex);
        this.headerRowIndex = headerRowIndex;
    }

    @Override
    public List<Map<String, Object>> read(Sheet sheet) {
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        if (this.headerRowIndex < firstRowNum) {
            throw new IndexOutOfBoundsException(StringKit.format("Header row index {} is lower than first row index {}.", this.headerRowIndex, firstRowNum));
        }
        if (this.headerRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(StringKit.format("Header row index {} is greater than last row index {}.", this.headerRowIndex, firstRowNum));
        }
        if (lastRowNum < 0) {
            return Collections.emptyList();
        }
        int startRowIndex = Math.max(this.startRowIndex, firstRowNum);
        int endRowIndex = Math.min(this.endRowIndex, lastRowNum);
        List<String> headerList = this.aliasHeader(this.readRow(sheet, this.headerRowIndex));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(endRowIndex - startRowIndex + 1);
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList;
            if (i == this.headerRowIndex || !CollKit.isNotEmpty(rowList = this.readRow(sheet, i)) && this.ignoreEmptyRow) continue;
            result.add(IterKit.toMap(headerList, rowList, true));
        }
        return result;
    }
}

