/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.proxy;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.aoju.bus.pager.PageException;
import org.aoju.bus.pager.dialect.AbstractSqlDialect;
import org.aoju.bus.pager.dialect.Dialect;
import org.aoju.bus.pager.dialect.general.Db2Dialect;
import org.aoju.bus.pager.dialect.general.HerdDBDialect;
import org.aoju.bus.pager.dialect.general.HsqldbDialect;
import org.aoju.bus.pager.dialect.general.InformixDialect;
import org.aoju.bus.pager.dialect.general.MySqlDialect;
import org.aoju.bus.pager.dialect.general.Oracle9iDialect;
import org.aoju.bus.pager.dialect.general.OracleDialect;
import org.aoju.bus.pager.dialect.general.SqlServer2012Dialect;
import org.aoju.bus.pager.dialect.general.SqlServerDialect;
import org.aoju.bus.pager.plugin.PageFromObject;
import org.apache.ibatis.mapping.MappedStatement;

public class PageAutoDialect {
    private static final Map<String, Class<? extends Dialect>> DIALECT_ALIAS_MAP = new HashMap<String, Class<? extends Dialect>>();
    private final Map<String, AbstractSqlDialect> urlDialectMap = new ConcurrentHashMap<String, AbstractSqlDialect>();
    private final ThreadLocal<AbstractSqlDialect> dialectThreadLocal = new ThreadLocal();
    private final ReentrantLock lock = new ReentrantLock();
    private boolean autoDialect = true;
    private boolean closeConn = true;
    private Properties properties;
    private AbstractSqlDialect delegate;

    public static void registerDialectAlias(String alias, Class<? extends Dialect> dialectClass) {
        DIALECT_ALIAS_MAP.put(alias, dialectClass);
    }

    public void initDelegateDialect(MappedStatement ms) {
        if (null == this.delegate) {
            if (this.autoDialect) {
                this.delegate = this.getDialect(ms);
            } else {
                this.dialectThreadLocal.set(this.getDialect(ms));
            }
        }
    }

    public AbstractSqlDialect getDelegate() {
        if (null != this.delegate) {
            return this.delegate;
        }
        return this.dialectThreadLocal.get();
    }

    public void clearDelegate() {
        this.dialectThreadLocal.remove();
    }

    private String fromJdbcUrl(String jdbcUrl) {
        for (String dialect : DIALECT_ALIAS_MAP.keySet()) {
            if (jdbcUrl.indexOf(":" + dialect + ":") == -1) continue;
            return dialect;
        }
        return null;
    }

    private Class resloveDialectClass(String className) throws Exception {
        if (DIALECT_ALIAS_MAP.containsKey(className.toLowerCase())) {
            return DIALECT_ALIAS_MAP.get(className.toLowerCase());
        }
        return Class.forName(className);
    }

    private AbstractSqlDialect initDialect(String dialectClass, Properties properties) {
        AbstractSqlDialect dialect;
        if (PageFromObject.isEmpty(dialectClass)) {
            throw new PageException("\u4f7f\u7528 PageContext \u5206\u9875\u63d2\u4ef6\u65f6,\u5fc5\u987b\u8bbe\u7f6e general \u5c5e\u6027");
        }
        try {
            Class sqlDialectClass = this.resloveDialectClass(dialectClass);
            if (!AbstractSqlDialect.class.isAssignableFrom(sqlDialectClass)) {
                throw new PageException("\u4f7f\u7528 PageContext \u65f6,\u65b9\u8a00\u5fc5\u987b\u662f\u5b9e\u73b0 " + AbstractSqlDialect.class.getCanonicalName() + " \u63a5\u53e3\u7684\u5b9e\u73b0\u7c7b!");
            }
            dialect = (AbstractSqlDialect)sqlDialectClass.newInstance();
        }
        catch (Exception e) {
            throw new PageException("\u521d\u59cb\u5316 general [" + dialectClass + "]\u65f6\u51fa\u9519:" + e.getMessage(), e);
        }
        dialect.setProperties(properties);
        return dialect;
    }

    private String getUrl(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String string = conn.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new PageException(e);
        }
        finally {
            if (null != conn) {
                try {
                    if (this.closeConn) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractSqlDialect getDialect(MappedStatement ms) {
        DataSource dataSource = ms.getConfiguration().getEnvironment().getDataSource();
        String url = this.getUrl(dataSource);
        if (this.urlDialectMap.containsKey(url)) {
            return this.urlDialectMap.get(url);
        }
        try {
            this.lock.lock();
            if (this.urlDialectMap.containsKey(url)) {
                AbstractSqlDialect abstractSqlDialect = this.urlDialectMap.get(url);
                return abstractSqlDialect;
            }
            if (PageFromObject.isEmpty(url)) {
                throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6jdbcUrl,\u8bf7\u5728\u5206\u9875\u63d2\u4ef6\u4e2d\u914d\u7f6edialect\u53c2\u6570!");
            }
            String dialectStr = this.fromJdbcUrl(url);
            if (null == dialectStr) {
                throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b,\u8bf7\u901a\u8fc7 helperDialect \u53c2\u6570\u6307\u5b9a!");
            }
            AbstractSqlDialect dialect = this.initDialect(dialectStr, this.properties);
            this.urlDialectMap.put(url, dialect);
            AbstractSqlDialect abstractSqlDialect = dialect;
            return abstractSqlDialect;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setProperties(Properties properties) {
        String dialectAlias;
        String useSqlserver2012;
        String closeConn = properties.getProperty("closeConn");
        if (PageFromObject.isNotEmpty(closeConn)) {
            this.closeConn = Boolean.parseBoolean(closeConn);
        }
        if (PageFromObject.isNotEmpty(useSqlserver2012 = properties.getProperty("useSqlserver2012")) && Boolean.parseBoolean(useSqlserver2012)) {
            PageAutoDialect.registerDialectAlias("sqlserver", SqlServer2012Dialect.class);
            PageAutoDialect.registerDialectAlias("sqlserver2008", SqlServerDialect.class);
        }
        if (PageFromObject.isNotEmpty(dialectAlias = properties.getProperty("dialectAlias"))) {
            String[] alias = dialectAlias.split(";");
            for (int i = 0; i < alias.length; ++i) {
                String[] kv = alias[i].split("=");
                if (kv.length != 2) {
                    throw new IllegalArgumentException("dialectAlias \u53c2\u6570\u914d\u7f6e\u9519\u8bef,\u8bf7\u6309\u7167 alias1=xx.dialectClass;alias2=dialectClass2 \u7684\u5f62\u5f0f\u8fdb\u884c\u914d\u7f6e!");
                }
                for (int j = 0; j < kv.length; ++j) {
                    try {
                        Class<?> diallectClass = Class.forName(kv[1]);
                        PageAutoDialect.registerDialectAlias(kv[0], diallectClass);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("\u8bf7\u786e\u4fdd dialectAlias \u914d\u7f6e\u7684 Dialect \u5b9e\u73b0\u7c7b\u5b58\u5728!", e);
                    }
                }
            }
        }
        String dialect = properties.getProperty("delegate");
        String runtimeDialect = properties.getProperty("autoRuntimeDialect");
        if (PageFromObject.isNotEmpty(runtimeDialect) && "TRUE".equalsIgnoreCase(runtimeDialect)) {
            this.autoDialect = false;
            this.properties = properties;
        } else if (PageFromObject.isEmpty(dialect)) {
            this.autoDialect = true;
            this.properties = properties;
        } else {
            this.autoDialect = false;
            this.delegate = this.initDialect(dialect, properties);
        }
    }

    static {
        PageAutoDialect.registerDialectAlias("db2", Db2Dialect.class);
        PageAutoDialect.registerDialectAlias("herddb", HerdDBDialect.class);
        PageAutoDialect.registerDialectAlias("hsqldb", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("h2", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("postgresql", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("phoenix", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("informix", InformixDialect.class);
        PageAutoDialect.registerDialectAlias("informix-sqli", InformixDialect.class);
        PageAutoDialect.registerDialectAlias("mysql", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("mariadb", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("sqlite", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("oscar", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("clickhouse", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("oracle9i", Oracle9iDialect.class);
        PageAutoDialect.registerDialectAlias("oracle", OracleDialect.class);
        PageAutoDialect.registerDialectAlias("dm", OracleDialect.class);
        PageAutoDialect.registerDialectAlias("edb", OracleDialect.class);
        PageAutoDialect.registerDialectAlias("sqlserver", SqlServerDialect.class);
        PageAutoDialect.registerDialectAlias("sqlserver2012", SqlServer2012Dialect.class);
        PageAutoDialect.registerDialectAlias("derby", SqlServer2012Dialect.class);
    }
}

