/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.aoju.bus.core.io.ByteBuffer;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.socket.BufferFactory;
import org.aoju.bus.socket.Protocol;
import org.aoju.bus.socket.ServerConfig;
import org.aoju.bus.socket.SocketStatus;
import org.aoju.bus.socket.TcpAioSession;
import org.aoju.bus.socket.handler.CompletionReadHandler;
import org.aoju.bus.socket.handler.CompletionWriteHandler;
import org.aoju.bus.socket.handler.ConcurrentReadHandler;
import org.aoju.bus.socket.process.MessageProcessor;

public class AioQuickServer<T> {
    private static final String BUS_ASYNCHRONOUS_CHANNEL_PROVIDER = "org.aoju.bus.socket.channel.AsynchronousChannelProvider";
    private static final String AIO_ASYNCHRONOUS_CHANNEL_PROVIDER = "java.nio.channels.spi.AsynchronousChannelProvider";
    private final ServerConfig<T> config = new ServerConfig();
    private ByteBuffer bufferPool;
    private CompletionReadHandler<T> aioCompletionReadHandler;
    private ThreadPoolExecutor concurrentReadCompletionHandlerExecutor;
    private CompletionWriteHandler<T> aioCompletionWriteHandler;
    private ByteBuffer innerBufferPool = null;
    private Function<AsynchronousSocketChannel, TcpAioSession<T>> aioSessionFunction;
    private AsynchronousServerSocketChannel serverSocketChannel = null;
    private AsynchronousChannelGroup asynchronousChannelGroup;
    private BufferFactory.VirtualBufferFactory readBufferFactory = bufferPage -> bufferPage.allocate(this.config.getReadBufferSize());

    public AioQuickServer(int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this.config.setPort(port);
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
        this.config.setThreadNum(Runtime.getRuntime().availableProcessors());
    }

    public AioQuickServer(String host, int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this(port, protocol, messageProcessor);
        this.config.setHost(host);
    }

    public void start() throws IOException {
        this.start0(channel -> new TcpAioSession<T>((AsynchronousSocketChannel)channel, this.config, this.aioCompletionReadHandler, this.aioCompletionWriteHandler, this.bufferPool.allocatePageBuffer()));
    }

    private void start0(Function<AsynchronousSocketChannel, TcpAioSession<T>> aioSessionFunction) throws IOException {
        this.checkAndResetConfig();
        try {
            this.aioCompletionWriteHandler = new CompletionWriteHandler();
            if (null == this.bufferPool) {
                this.innerBufferPool = this.bufferPool = this.config.getBufferFactory().create();
            }
            this.aioSessionFunction = aioSessionFunction;
            if (BUS_ASYNCHRONOUS_CHANNEL_PROVIDER.equals(System.getProperty(AIO_ASYNCHRONOUS_CHANNEL_PROVIDER))) {
                this.aioCompletionReadHandler = new CompletionReadHandler();
            } else {
                this.concurrentReadCompletionHandlerExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
                this.aioCompletionReadHandler = new ConcurrentReadHandler(new Semaphore(this.config.getThreadNum() - 1), this.concurrentReadCompletionHandlerExecutor);
            }
            this.asynchronousChannelGroup = AsynchronousChannelGroup.withFixedThreadPool(this.config.getThreadNum(), new ThreadFactory(){
                private byte index = 0;

                @Override
                public Thread newThread(Runnable r) {
                    this.index = (byte)(this.index + 1);
                    return AioQuickServer.this.bufferPool.newThread(r, "bus-socket:Thread-" + this.index);
                }
            });
            this.serverSocketChannel = AsynchronousServerSocketChannel.open(this.asynchronousChannelGroup);
            if (null != this.config.getSocketOptions()) {
                for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                    this.serverSocketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            if (null != this.config.getHost()) {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getHost(), this.config.getPort()), this.config.getBacklog());
            } else {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getPort()), this.config.getBacklog());
            }
            this.startAcceptThread();
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
        System.out.println("bus-socket server started on port " + this.config.getPort() + ",threadNum:" + this.config.getThreadNum());
        System.out.println("bus-socket server config is " + this.config);
    }

    private void startAcceptThread() {
        this.serverSocketChannel.accept(null, new CompletionHandler<AsynchronousSocketChannel, Void>(){

            @Override
            public void completed(AsynchronousSocketChannel channel, Void attachment) {
                AioQuickServer.this.createSession(channel);
                try {
                    AioQuickServer.this.serverSocketChannel.accept(attachment, this);
                }
                catch (Throwable throwable) {
                    AioQuickServer.this.config.getProcessor().stateEvent(null, SocketStatus.ACCEPT_EXCEPTION, throwable);
                    this.failed(throwable, attachment);
                    AioQuickServer.this.serverSocketChannel.accept(attachment, this);
                }
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                exc.printStackTrace();
            }
        });
    }

    private void checkAndResetConfig() {
        if (this.config.getThreadNum() == 1) {
            this.config.setThreadNum(2);
        }
    }

    private void createSession(AsynchronousSocketChannel channel) {
        TcpAioSession<T> session = null;
        AsynchronousSocketChannel acceptChannel = channel;
        try {
            if (null != this.config.getMonitor()) {
                acceptChannel = this.config.getMonitor().shouldAccept(channel);
            }
            if (null != acceptChannel) {
                acceptChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                session = this.aioSessionFunction.apply(acceptChannel);
                session.initSession(this.readBufferFactory.newBuffer(this.bufferPool.allocatePageBuffer()));
            } else {
                this.config.getProcessor().stateEvent(null, SocketStatus.REJECT_ACCEPT, null);
                IoKit.close(channel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (null == session) {
                IoKit.close(channel);
            }
            session.close();
        }
    }

    public final void shutdown() {
        try {
            if (null != this.serverSocketChannel) {
                this.serverSocketChannel.close();
                this.serverSocketChannel = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!this.asynchronousChannelGroup.isTerminated()) {
            try {
                this.asynchronousChannelGroup.shutdownNow();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.asynchronousChannelGroup.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (null != this.innerBufferPool) {
            this.innerBufferPool.release();
        }
        if (this.concurrentReadCompletionHandlerExecutor != null) {
            this.concurrentReadCompletionHandlerExecutor.shutdown();
            this.concurrentReadCompletionHandlerExecutor = null;
        }
    }

    public final AioQuickServer<T> setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final <V> AioQuickServer<T> setOption(SocketOption<V> socketOption, V value) {
        this.config.setOption(socketOption, value);
        return this;
    }

    public final AioQuickServer<T> setThreadNum(int threadNum) {
        if (threadNum <= 1) {
            throw new InvalidParameterException("threadNum must >= 2");
        }
        this.config.setThreadNum(threadNum);
        return this;
    }

    public final AioQuickServer<T> setWriteBuffer(int bufferSize, int bufferCapacity) {
        this.config.setWriteBufferSize(bufferSize);
        this.config.setWriteBufferCapacity(bufferCapacity);
        return this;
    }

    public final AioQuickServer<T> setBacklog(int backlog) {
        this.config.setBacklog(backlog);
        return this;
    }

    public final AioQuickServer<T> setPageBufferPool(ByteBuffer bufferPool) {
        this.bufferPool = bufferPool;
        this.config.setBufferFactory(BufferFactory.DISABLED_BUFFER_FACTORY);
        return this;
    }

    public final AioQuickServer<T> setBufferFactory(BufferFactory bufferFactory) {
        this.config.setBufferFactory(bufferFactory);
        this.bufferPool = null;
        return this;
    }

    public final AioQuickServer<T> setReadBufferFactory(BufferFactory.VirtualBufferFactory readBufferFactory) {
        this.readBufferFactory = readBufferFactory;
        return this;
    }
}

