/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.base.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.base.entity.BaseEntity;
import org.aoju.bus.base.entity.Entity;
import org.aoju.bus.base.entity.Result;
import org.aoju.bus.base.mapper.BaseMapper;
import org.aoju.bus.base.service.BaseService;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.mapper.entity.Condition;
import org.aoju.bus.pager.Page;
import org.aoju.bus.pager.PageContext;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseServiceImpl<Mapper extends BaseMapper<T>, T extends BaseEntity>
implements BaseService<T> {
    @Autowired
    protected Mapper mapper;

    @Override
    public String insert(T entity) {
        this.setValue(entity);
        this.mapper.insert(entity);
        return ((Entity)entity).getId();
    }

    @Override
    public String insertSelective(T entity) {
        this.setValue(entity);
        this.mapper.insertSelective(entity);
        return ((Entity)entity).getId();
    }

    @Override
    public Object insertBatch(List<T> list) {
        ArrayList data = new ArrayList();
        list.forEach(item -> {
            String id = this.insertSelective((T)item);
            data.add(id);
        });
        return data;
    }

    @Override
    public Object insertBatchSelective(List<T> list) {
        ArrayList data = new ArrayList();
        list.forEach(item -> {
            String id = this.insertSelective((T)item);
            data.add(id);
        });
        return data;
    }

    @Override
    public void delete(T entity) {
        this.mapper.delete(entity);
    }

    @Override
    public void deleteById(Object id) {
        this.mapper.deleteByPrimaryKey(id);
    }

    @Override
    public int deleteByIds(String id) {
        return this.mapper.deleteByIds(StringKit.split(id));
    }

    @Override
    public int deleteByWhere(Object object) {
        return this.mapper.deleteByWhere(object);
    }

    @Override
    public void updateById(T entity) {
        ((BaseEntity)entity).setUpdatedInfo(entity);
        this.mapper.updateByPrimaryKey(entity);
    }

    @Override
    public int updateSelectiveById(T entity) {
        ((BaseEntity)entity).setUpdatedInfo(entity);
        return this.mapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    public T updateByIdCas(T entity, String locking) {
        Condition condition = new Condition(entity.getClass());
        Object before = ObjectKit.getAttributeValue(entity, locking);
        Object id = ObjectKit.getAttributeValue(entity, "id");
        condition.createCriteria().andEqualTo(locking, before);
        condition.createCriteria().andEqualTo("id", id);
        this.updateByWhereSelective(entity, (Object)condition);
        return entity;
    }

    @Override
    public T updateSelectiveByIdOrInsert(T entity) {
        if (StringKit.isEmpty(((Entity)entity).getId())) {
            this.insert(entity);
        } else {
            ((BaseEntity)entity).setUpdatedInfo(entity);
            this.mapper.updateByPrimaryKeySelective(entity);
        }
        return entity;
    }

    @Override
    public int updateByWhere(T entity, Object object) {
        ((BaseEntity)entity).setUpdatedInfo(entity);
        return this.mapper.updateByWhere(entity, object);
    }

    @Override
    public int updateByWhereSelective(T entity, Object object) {
        ((BaseEntity)entity).setUpdatedInfo(entity);
        return this.mapper.updateByWhereSelective(entity, object);
    }

    @Override
    public int updateStatus(T entity) {
        ((BaseEntity)entity).setUpdatedInfo(entity);
        return this.mapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    public T selectOne(T entity) {
        return (T)((BaseEntity)this.mapper.selectOne(entity));
    }

    @Override
    public T selectById(Object id) {
        return (T)((BaseEntity)this.mapper.selectByPrimaryKey(id));
    }

    @Override
    public int selectCountByWhere(Object object) {
        return this.mapper.selectCountByWhere(object);
    }

    @Override
    public Long selectCount(T entity) {
        return new Long(this.mapper.selectCount(entity));
    }

    @Override
    public List<T> selectListByIds(String id) {
        return this.mapper.selectByIds(StringKit.split(id));
    }

    @Override
    public List<T> selectList(T entity) {
        return this.mapper.select(entity);
    }

    @Override
    public List<T> selectListAll() {
        return this.mapper.selectAll();
    }

    @Override
    public List<T> selectByWhere(Object where) {
        return this.mapper.selectByWhere(where);
    }

    @Override
    public Result<T> page(T entity) {
        PageContext.startPage(((Entity)entity).getPageNo(), ((Entity)entity).getPageSize());
        if (StringKit.isNotEmpty(((Entity)entity).getOrderBy())) {
            PageContext.orderBy(((Entity)entity).getOrderBy());
        }
        Page list = (Page)this.mapper.select(entity);
        return new Result((int)list.getTotal(), list.getResult());
    }

    private String setValue(T entity) {
        if (ObjectKit.isEmpty(entity)) {
            return null;
        }
        if (StringKit.isEmpty(((BaseEntity)entity).getStatus())) {
            ((BaseEntity)entity).setStatus("1");
        }
        ((BaseEntity)entity).setCreateInfo(entity);
        ((BaseEntity)entity).setUpdatedInfo(entity);
        return ((Entity)entity).getId();
    }
}

