/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec;

import java.io.IOException;
import java.io.OutputStream;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Base64Decoder {
    private static final byte PADDING = -2;

    public static String decodeStr(CharSequence source) {
        return Base64Decoder.decodeStr(source, Charset.UTF_8);
    }

    public static String decodeStr(CharSequence source, java.nio.charset.Charset charset) {
        return StringKit.toString(Base64Decoder.decode(source), charset);
    }

    public static byte[] decode(CharSequence source) {
        return Base64Decoder.decode(StringKit.bytes(source, Charset.UTF_8));
    }

    public static byte[] decode(byte[] in) {
        if (ArrayKit.isEmpty(in)) {
            return in;
        }
        return Base64Decoder.decode(in, 0, in.length);
    }

    public static byte[] decode(byte[] in, int pos, int length) {
        if (ArrayKit.isEmpty(in)) {
            return in;
        }
        IntWrapper offset = new IntWrapper(pos);
        int maxPos = pos + length - 1;
        int octetId = 0;
        byte[] octet = new byte[length * 3 / 4];
        while (offset.value <= maxPos) {
            byte sestet0 = Base64Decoder.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet1 = Base64Decoder.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet2 = Base64Decoder.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet3 = Base64Decoder.getNextValidDecodeByte(in, offset, maxPos);
            if (-2 != sestet1) {
                octet[octetId++] = (byte)(sestet0 << 2 | sestet1 >>> 4);
            }
            if (-2 != sestet2) {
                octet[octetId++] = (byte)((sestet1 & 0xF) << 4 | sestet2 >>> 2);
            }
            if (-2 == sestet3) continue;
            octet[octetId++] = (byte)((sestet2 & 3) << 6 | sestet3);
        }
        if (octetId == octet.length) {
            return octet;
        }
        return (byte[])ArrayKit.copy(octet, new byte[octetId], octetId);
    }

    public static void decode(char[] ch, int off, int len, OutputStream out) throws IOException {
        while ((len -= 2) >= 0) {
            int n = off++;
            byte b2 = Normal.DECODE_64_TABLE[ch[off++]];
            out.write((byte)(Normal.DECODE_64_TABLE[ch[n]] << 2 | b2 >>> 4));
            if (len-- == 0 || ch[off] == '=') break;
            byte b3 = Normal.DECODE_64_TABLE[ch[off++]];
            out.write((byte)(b2 << 4 | b3 >>> 2));
            if (len-- == 0 || ch[off] == '=') break;
            out.write((byte)(b3 << 6 | Normal.DECODE_64_TABLE[ch[off++]]));
        }
    }

    public static boolean isBase64Code(byte octet) {
        return octet == 61 || octet >= 0 && octet < Normal.DECODE_64_TABLE.length && Normal.DECODE_64_TABLE[octet] != -1;
    }

    private static byte getNextValidDecodeByte(byte[] in, IntWrapper pos, int maxPos) {
        while (pos.value <= maxPos) {
            byte decodeByte;
            byte base64Byte;
            if ((base64Byte = in[pos.value++]) <= -1 || (decodeByte = Normal.DECODE_64_TABLE[base64Byte]) <= -1) continue;
            return decodeByte;
        }
        return -2;
    }

    private static class IntWrapper {
        int value;

        IntWrapper(int value) {
            this.value = value;
        }
    }
}

