/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class NumberWord {
    public static String format(Object x) {
        if (null != x) {
            return NumberWord.format(x.toString());
        }
        return "";
    }

    private static String format(String x) {
        String lstr;
        int z = x.indexOf(".");
        String rstr = "";
        if (z > -1) {
            lstr = x.substring(0, z);
            rstr = x.substring(z + 1);
        } else {
            lstr = x;
        }
        String lstrrev = StringKit.reverse(lstr);
        String[] a = new String[5];
        switch (lstrrev.length() % 3) {
            case 1: {
                lstrrev = lstrrev + "00";
                break;
            }
            case 2: {
                lstrrev = lstrrev + "0";
            }
        }
        String lm = "";
        for (int i = 0; i < lstrrev.length() / 3; ++i) {
            a[i] = StringKit.reverse(lstrrev.substring(3 * i, 3 * i + 3));
            if (!ObjectKit.equal(a[i], "000")) {
                if (i != 0) {
                    lm = NumberWord.transThree(a[i]) + " " + NumberWord.parseMore(String.valueOf(i)) + " " + lm;
                    continue;
                }
                lm = NumberWord.transThree(a[i]);
                continue;
            }
            lm = lm + NumberWord.transThree(a[i]);
        }
        String xs = "";
        if (z > -1) {
            xs = "AND CENTS " + NumberWord.transTwo(rstr) + " ";
        }
        return lm.trim() + " " + xs + "ONLY";
    }

    public static String formatSimple(long value) {
        return NumberWord.formatSimple(value, true);
    }

    public static String formatSimple(long value, boolean isTwo) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        int index = -1;
        double res = value;
        while (res > 10.0 && (!isTwo || index < 1)) {
            if (res > 1000.0) {
                res /= 1000.0;
                ++index;
            }
            if (!(res > 10.0)) continue;
            res /= 10.0;
            ++index;
        }
        return String.format("%s%s", MathKit.decimalFormat("#.##", res), Normal.NUMBER_SUFFIX[index]);
    }

    private static String parseFirst(String s) {
        return Normal.EN_NUMBER[Integer.parseInt(s.substring(s.length() - 1))];
    }

    private static String parseTeen(String s) {
        return Normal.NUMBER_TEEN[Integer.parseInt(s) - 10];
    }

    private static String parseTen(String s) {
        return Normal.NUMBER_TEN[Integer.parseInt(s.substring(0, 1)) - 1];
    }

    private static String parseMore(String s) {
        return Normal.NUMBER_MORE[Integer.parseInt(s)];
    }

    private static String transTwo(String s) {
        if (s.length() > 2) {
            s = s.substring(0, 2);
        } else if (s.length() < 2) {
            s = "0" + s;
        }
        String value = s.startsWith("0") ? NumberWord.parseFirst(s) : (s.startsWith("1") ? NumberWord.parseTeen(s) : (s.endsWith("0") ? NumberWord.parseTen(s) : NumberWord.parseTen(s) + " " + NumberWord.parseFirst(s)));
        return value;
    }

    private static String transThree(String s) {
        String value = s.startsWith("0") ? NumberWord.transTwo(s.substring(1)) : (ObjectKit.equal(s.substring(1), "00") ? NumberWord.parseFirst(s.substring(0, 1)) + " HUNDRED" : NumberWord.parseFirst(s.substring(0, 1)) + " HUNDRED AND " + NumberWord.transTwo(s.substring(1)));
        return value;
    }
}

