/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.file.visitor;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.aoju.bus.core.toolkit.FileKit;

public class CopyVisitor
extends SimpleFileVisitor<Path> {
    private final Path source;
    private final Path target;
    private boolean isTargetCreated;

    public CopyVisitor(Path source, Path target) {
        if (FileKit.exists(target, false) && !FileKit.isDirectory(target)) {
            throw new IllegalArgumentException("Target must be a directory");
        }
        this.source = source;
        this.target = target;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        block2: {
            this.initTarget();
            Path targetDir = this.target.resolve(this.source.relativize(dir));
            try {
                Files.copy(dir, targetDir, new CopyOption[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                throw e;
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        this.initTarget();
        Files.copy(file, this.target.resolve(this.source.relativize(file)), new CopyOption[0]);
        return FileVisitResult.CONTINUE;
    }

    private void initTarget() {
        if (!this.isTargetCreated) {
            FileKit.mkdir(this.target);
            this.isTargetCreated = true;
        }
    }
}

