/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.tree;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.tree.Node;
import org.aoju.bus.core.lang.tree.NodeConfig;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.TreeKit;

public class Tree<T>
extends LinkedHashMap<String, Object>
implements Node<T> {
    private static final long serialVersionUID = 1L;
    private final NodeConfig nodeConfig;
    private Tree<T> parent;

    public Tree() {
        this((NodeConfig)null);
    }

    public Tree(NodeConfig nodeConfig) {
        this.nodeConfig = ObjectKit.defaultIfNull(nodeConfig, NodeConfig.DEFAULT_CONFIG);
    }

    private static void printTree(Tree<?> tree, PrintWriter writer, int intent) {
        writer.println(StringKit.format("{}{}[{}]", StringKit.repeat(" ", intent), tree.getName(), tree.getId()));
        writer.flush();
        List<Tree<?>> children = tree.getChildren();
        if (CollKit.isNotEmpty(children)) {
            for (Tree<?> child : children) {
                Tree.printTree(child, writer, intent + 2);
            }
        }
    }

    public NodeConfig getConfig() {
        return this.nodeConfig;
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public Tree<T> setParent(Tree<T> parent) {
        this.parent = parent;
        if (null != parent) {
            this.setParentId((Object)parent.getId());
        }
        return this;
    }

    public Tree<T> getNode(T id) {
        return TreeKit.getNode(this, id);
    }

    public List<CharSequence> getParentsName(T id, boolean includeCurrentNode) {
        return TreeKit.getParentsName(this.getNode(id), includeCurrentNode);
    }

    public List<CharSequence> getParentsName(boolean includeCurrentNode) {
        return TreeKit.getParentsName(this, includeCurrentNode);
    }

    @Override
    public T getId() {
        return (T)this.get(this.nodeConfig.getIdKey());
    }

    @Override
    public Tree<T> setId(T id) {
        this.put(this.nodeConfig.getIdKey(), id);
        return this;
    }

    @Override
    public T getParentId() {
        return (T)this.get(this.nodeConfig.getParentIdKey());
    }

    @Override
    public Tree<T> setParentId(T parentId) {
        this.put(this.nodeConfig.getParentIdKey(), parentId);
        return this;
    }

    @Override
    public CharSequence getName() {
        return (CharSequence)this.get(this.nodeConfig.getNameKey());
    }

    @Override
    public Tree<T> setName(CharSequence name) {
        this.put(this.nodeConfig.getNameKey(), name);
        return this;
    }

    @Override
    public Comparable<?> getWeight() {
        return (Comparable)this.get(this.nodeConfig.getWeightKey());
    }

    @Override
    public Tree<T> setWeight(Comparable<?> weight) {
        this.put(this.nodeConfig.getWeightKey(), weight);
        return this;
    }

    public List<Tree<T>> getChildren() {
        return (List)this.get(this.nodeConfig.getChildrenKey());
    }

    public Tree<T> setChildren(List<Tree<T>> children) {
        this.put(this.nodeConfig.getChildrenKey(), children);
        return this;
    }

    @SafeVarargs
    public final Tree<T> addChildren(Tree<T> ... children) {
        if (ArrayKit.isNotEmpty(children)) {
            List<Tree<T>> childrenList = this.getChildren();
            if (null == childrenList) {
                childrenList = new ArrayList<Tree<T>>();
                this.setChildren(childrenList);
            }
            for (Tree<T> child : children) {
                child.setParent(this);
                childrenList.add(child);
            }
        }
        return this;
    }

    public void putExtra(String key, Object value) {
        Assert.notEmpty(key, "Key must be not empty !", new Object[0]);
        this.put(key, value);
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        Tree.printTree(this, new PrintWriter(stringWriter), 0);
        return stringWriter.toString();
    }
}

