/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.loader;

import java.io.Serializable;
import java.util.function.Supplier;

public class LazyLoader<T>
implements Supplier<T>,
Serializable {
    private volatile transient Supplier<? extends T> supplier;
    private T value;

    private LazyLoader(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <T> LazyLoader<T> of(Supplier<T> supplier) {
        return new LazyLoader<T>(supplier);
    }

    @Override
    public T get() {
        return null == this.supplier ? this.value : this.computeValue();
    }

    private synchronized T computeValue() {
        Supplier<T> s = this.supplier;
        if (null != s) {
            this.value = s.get();
            this.supplier = null;
        }
        return this.value;
    }
}

