/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.text.csv.CsvData;
import org.aoju.bus.core.text.csv.CsvHandler;
import org.aoju.bus.core.text.csv.CsvParser;
import org.aoju.bus.core.text.csv.CsvReadConfig;
import org.aoju.bus.core.text.csv.CsvRow;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public final class CsvReader {
    CsvReadConfig config;

    public CsvReader() {
        this(null);
    }

    public CsvReader(CsvReadConfig config) {
        this.config = ObjectKit.defaultIfNull(config, CsvReadConfig.defaultConfig());
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.config.setFieldSeparator(fieldSeparator);
    }

    public void setTextDelimiter(char textDelimiter) {
        this.config.setTextDelimiter(textDelimiter);
    }

    public void setContainsHeader(boolean containsHeader) {
        this.config.setContainsHeader(containsHeader);
    }

    public void setSkipEmptyRows(boolean skipEmptyRows) {
        this.config.setSkipEmptyRows(skipEmptyRows);
    }

    public void setErrorOnDifferentFieldCount(boolean errorOnDifferentFieldCount) {
        this.setErrorOnDifferentFieldCount(errorOnDifferentFieldCount);
    }

    public CsvData read(File file) throws InstrumentException {
        return this.read(file, Charset.UTF_8);
    }

    public CsvData read(File file, java.nio.charset.Charset charset) throws InstrumentException {
        return this.read(Objects.requireNonNull(file.toPath(), "file must not be null"), charset);
    }

    public CsvData read(Path path) throws InstrumentException {
        return this.read(path, Charset.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CsvData read(Path path, java.nio.charset.Charset charset) throws InstrumentException {
        Assert.notNull(path, "path must not be null", new Object[0]);
        try (BufferedReader reader = FileKit.getReader(path, charset);){
            CsvData csvData = this.read(reader);
            return csvData;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public CsvData read(Reader reader) throws InstrumentException {
        CsvParser csvParser = this.parse(reader);
        ArrayList<CsvRow> rows = new ArrayList<CsvRow>();
        this.read(csvParser, rows::add);
        List<String> header = this.config.containsHeader ? csvParser.getHeader() : null;
        return new CsvData(header, rows);
    }

    public void read(Reader reader, CsvHandler rowHandler) {
        this.read(this.parse(reader), rowHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(CsvParser csvParser, CsvHandler rowHandler) {
        try {
            CsvRow csvRow;
            while (null != (csvRow = csvParser.nextRow())) {
                rowHandler.handle(csvRow);
            }
        }
        finally {
            IoKit.close(csvParser);
        }
    }

    public List<Map<String, String>> readMapList(Reader reader) throws InstrumentException {
        this.config.setContainsHeader(true);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        this.read(reader, (CsvRow row) -> result.add(row.getFieldMap()));
        return result;
    }

    public <T> List<T> read(Reader reader, Class<T> clazz) {
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read(reader, (CsvRow row) -> result.add(row.toBean(clazz)));
        return result;
    }

    private CsvParser parse(Reader reader) throws InstrumentException {
        return new CsvParser(reader, this.config);
    }

    public <T> List<T> read(Reader reader, int startLineIndex, Class<T> clazz) {
        if (startLineIndex < 1) {
            throw new IndexOutOfBoundsException(StringKit.format("start line index {} is lower than first row index 1.", startLineIndex));
        }
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read(reader, (CsvRow row) -> {
            if (row.getOriginalLineNumber() >= (long)startLineIndex) {
                result.add(row.toBean(clazz));
            }
        });
        return result;
    }
}

