/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import org.aoju.bus.core.lang.Charset;

public class ByteKit {
    public static byte getByte(int data) {
        return (byte)data;
    }

    public static byte[] getBytes(int data) {
        return ByteKit.getBytes(data, ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] getBytes(int ... data) {
        byte[] ret = new byte[4 * data.length];
        for (int i = 0; i < data.length; ++i) {
            ByteKit.intToBytesLE(data[i], ret, 4 * i);
        }
        return ret;
    }

    public static byte[] getBytes(int data, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return new byte[]{(byte)(data >> 24 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data & 0xFF)};
        }
        return new byte[]{(byte)(data & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 24 & 0xFF)};
    }

    public static byte[] getBytes(long data) {
        return ByteKit.getBytes(data, ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] getBytes(long data, ByteOrder byteOrder) {
        byte[] result = new byte[8];
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = result.length - 1; i >= 0; --i) {
                result[i] = (byte)(data & 0xFFL);
                data >>= 8;
            }
        } else {
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)(data & 0xFFL);
                data >>= 8;
            }
        }
        return result;
    }

    public static byte[] getBytes(float data) {
        return ByteKit.getBytes(data, ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] getBytes(float data, ByteOrder byteOrder) {
        return ByteKit.getBytes(Float.floatToIntBits(data), byteOrder);
    }

    public static byte[] getBytes(double data) {
        return ByteKit.getBytes(data, ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] getBytes(double data, ByteOrder byteOrder) {
        return ByteKit.getBytes(Double.doubleToLongBits(data), byteOrder);
    }

    public static byte[] getBytes(short data) {
        return ByteKit.getBytes(data, ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] getBytes(short data, ByteOrder byteOrder) {
        byte[] b = new byte[2];
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            b[1] = (byte)(data & 0xFF);
            b[0] = (byte)(data >> 8 & 0xFF);
        } else {
            b[0] = (byte)(data & 0xFF);
            b[1] = (byte)(data >> 8 & 0xFF);
        }
        return b;
    }

    public static byte[] getBytes(char data) {
        byte[] bytes = new byte[]{(byte)data, (byte)(data >> 8)};
        return bytes;
    }

    public static byte[] getBytes(char[] data) {
        CharBuffer cb = CharBuffer.allocate(data.length);
        cb.put(data);
        cb.flip();
        ByteBuffer bb = Charset.UTF_8.encode(cb);
        return bb.array();
    }

    public static byte[] getBytes(String data) {
        return ByteKit.getBytes(data, "GBK");
    }

    public static byte[] getBytes(String data, String charset) {
        return data.getBytes(Charset.charset(charset));
    }

    public static int getInt(byte data) {
        return data & 0xFF;
    }

    public static int getInt(byte[] data) {
        return ByteKit.getInt(data, ByteOrder.LITTLE_ENDIAN);
    }

    public static int getInt(byte[] data, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return data[3] & 0xFF | (data[2] & 0xFF) << 8 | (data[1] & 0xFF) << 16 | (data[0] & 0xFF) << 24;
        }
        return data[0] & 0xFF | (data[1] & 0xFF) << 8 | (data[2] & 0xFF) << 16 | (data[3] & 0xFF) << 24;
    }

    public static long getLong(byte[] data) {
        return ByteKit.getLong(data, ByteOrder.LITTLE_ENDIAN);
    }

    public static long getLong(byte[] data, ByteOrder byteOrder) {
        long values = 0L;
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = 0; i < 8; ++i) {
                values <<= 8;
                values |= (long)(data[i] & 0xFF);
            }
        } else {
            for (int i = 7; i >= 0; --i) {
                values <<= 8;
                values |= (long)(data[i] & 0xFF);
            }
        }
        return values;
    }

    public static float getFloat(byte[] data) {
        return ByteKit.getFloat(data, ByteOrder.LITTLE_ENDIAN);
    }

    public static float getFloat(byte[] data, ByteOrder byteOrder) {
        return Float.intBitsToFloat(ByteKit.getInt(data, byteOrder));
    }

    public static double getDouble(byte[] data) {
        return ByteKit.getDouble(data, ByteOrder.LITTLE_ENDIAN);
    }

    public static double getDouble(byte[] data, ByteOrder byteOrder) {
        return Double.longBitsToDouble(ByteKit.getLong(data, byteOrder));
    }

    public static short getShort(byte[] data) {
        return ByteKit.getShort(data, ByteOrder.LITTLE_ENDIAN);
    }

    public static short getShort(byte[] data, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return (short)(data[1] & 0xFF | (data[0] & 0xFF) << 8);
        }
        return (short)(data[0] & 0xFF | (data[1] & 0xFF) << 8);
    }

    public static char getChar(byte[] data) {
        return (char)(0xFF & data[0] | 0xFF00 & data[1] << 8);
    }

    public static String getString(byte[] data) {
        return ByteKit.getString(data, "GBK");
    }

    public static String getString(byte[] data, String charset) {
        return new String(data, Charset.charset(charset));
    }

    public static byte[] getBytes(Number data) {
        if (data instanceof Double) {
            return ByteKit.getBytes((Double)data, ByteOrder.LITTLE_ENDIAN);
        }
        if (data instanceof Long) {
            return ByteKit.getBytes((Long)data, ByteOrder.LITTLE_ENDIAN);
        }
        if (data instanceof Integer) {
            return ByteKit.getBytes((int)((Integer)data), ByteOrder.LITTLE_ENDIAN);
        }
        if (data instanceof Short) {
            return ByteKit.getBytes((Short)data, ByteOrder.LITTLE_ENDIAN);
        }
        return ByteKit.getBytes(data.doubleValue(), ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[][] split(byte[] data, byte separator) {
        int count = ByteKit.countOf(data, separator);
        byte[][] result = new byte[count + 1][];
        int index = ByteKit.indexOf(data, separator, 0, data.length);
        if (index < 0) {
            result[0] = data;
        } else {
            result[0] = ByteKit.subArray(data, 0, index);
            for (int i = 1; i <= count; ++i) {
                int from = index + 1;
                if ((index = ByteKit.indexOf(data, separator, from, data.length)) < from) {
                    index = data.length;
                }
                result[i] = ByteKit.subArray(data, from, index);
            }
        }
        return result;
    }

    public static byte[][] split(byte[] data, int len) {
        int x = data.length / len;
        int y = data.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        for (int i = 0; i < x + z; ++i) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(data, i * len, arr, 0, y);
            } else {
                System.arraycopy(data, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }

    public static byte[] subArray(byte[] data, int from) {
        return ByteKit.subArray(data, from, data.length);
    }

    public static byte[] subArray(byte[] data, int from, int to) {
        byte[] result = new byte[to - from];
        if (to > from) {
            System.arraycopy(data, from, result, 0, result.length);
        }
        return result;
    }

    public static byte[] join(byte data, byte[] ... datas) {
        int length = 0;
        for (byte[] arr : datas) {
            length += arr.length;
        }
        byte[] result = new byte[length + datas.length - 1];
        int index = 0;
        for (int i = 0; i < datas.length; ++i) {
            byte[] arr;
            arr = datas[i];
            System.arraycopy(arr, 0, result, index, arr.length);
            index += arr.length;
            if (i >= datas.length - 1) continue;
            result[index] = data;
            ++index;
        }
        return result;
    }

    public static byte[] join(byte[] ... data) {
        int length = 0;
        for (byte[] arr : data) {
            length += arr.length;
        }
        byte[] result = new byte[length];
        int index = 0;
        for (byte[] arr : data) {
            System.arraycopy(arr, 0, result, index, arr.length);
            index += arr.length;
        }
        return result;
    }

    public static byte[] trim(byte[] data, byte empty) {
        return ByteKit.trim(data, empty, 0, data.length);
    }

    public static byte[] trim(byte[] data, byte empty, int from, int to) {
        while (from < data.length - 1 && data[from] == empty) {
            ++from;
        }
        while (to > from && data[to - 1] == empty) {
            --to;
        }
        return ByteKit.subArray(data, from, to);
    }

    public static int bytesToShort(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToShortBE(data, off) : ByteKit.bytesToShortLE(data, off);
    }

    public static int bytesToShortBE(byte[] data, int off) {
        return (data[off] << 8) + (data[off + 1] & 0xFF);
    }

    public static int bytesToShortLE(byte[] data, int off) {
        return (data[off + 1] << 8) + (data[off] & 0xFF);
    }

    public static int bytesToUShort(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToUShortBE(data, off) : ByteKit.bytesToUShortLE(data, off);
    }

    public static int bytesToUShortBE(byte[] data, int off) {
        return ((data[off] & 0xFF) << 8) + (data[off + 1] & 0xFF);
    }

    public static int bytesToUShortLE(byte[] data, int off) {
        return ((data[off + 1] & 0xFF) << 8) + (data[off] & 0xFF);
    }

    public static int bytesToVR(byte[] data, int off) {
        return ByteKit.bytesToUShortBE(data, off);
    }

    public static int bytesToInt(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToIntBE(data, off) : ByteKit.bytesToIntLE(data, off);
    }

    public static int bytesToIntBE(byte[] data, int off) {
        return (data[off] << 24) + ((data[off + 1] & 0xFF) << 16) + ((data[off + 2] & 0xFF) << 8) + (data[off + 3] & 0xFF);
    }

    public static int bytesToIntLE(byte[] data, int off) {
        return (data[off + 3] << 24) + ((data[off + 2] & 0xFF) << 16) + ((data[off + 1] & 0xFF) << 8) + (data[off] & 0xFF);
    }

    public static int bytesToTag(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToTagBE(data, off) : ByteKit.bytesToTagLE(data, off);
    }

    public static int bytesToTagBE(byte[] data, int off) {
        return ByteKit.bytesToIntBE(data, off);
    }

    public static int bytesToTagLE(byte[] data, int off) {
        return (data[off + 1] << 24) + ((data[off] & 0xFF) << 16) + ((data[off + 3] & 0xFF) << 8) + (data[off + 2] & 0xFF);
    }

    public static float bytesToFloat(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToFloatBE(data, off) : ByteKit.bytesToFloatLE(data, off);
    }

    public static float bytesToFloatBE(byte[] data, int off) {
        return Float.intBitsToFloat(ByteKit.bytesToIntBE(data, off));
    }

    public static float bytesToFloatLE(byte[] data, int off) {
        return Float.intBitsToFloat(ByteKit.bytesToIntLE(data, off));
    }

    public static long bytesToLong(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToLongBE(data, off) : ByteKit.bytesToLongLE(data, off);
    }

    public static long bytesToLongBE(byte[] data, int off) {
        return ((long)data[off] << 56) + ((long)(data[off + 1] & 0xFF) << 48) + ((long)(data[off + 2] & 0xFF) << 40) + ((long)(data[off + 3] & 0xFF) << 32) + ((long)(data[off + 4] & 0xFF) << 24) + (long)((data[off + 5] & 0xFF) << 16) + (long)((data[off + 6] & 0xFF) << 8) + (long)(data[off + 7] & 0xFF);
    }

    public static long bytesToLongLE(byte[] data, int off) {
        return ((long)data[off + 7] << 56) + ((long)(data[off + 6] & 0xFF) << 48) + ((long)(data[off + 5] & 0xFF) << 40) + ((long)(data[off + 4] & 0xFF) << 32) + ((long)(data[off + 3] & 0xFF) << 24) + (long)((data[off + 2] & 0xFF) << 16) + (long)((data[off + 1] & 0xFF) << 8) + (long)(data[off] & 0xFF);
    }

    public static double bytesToDouble(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToDoubleBE(data, off) : ByteKit.bytesToDoubleLE(data, off);
    }

    public static double bytesToDoubleBE(byte[] data, int off) {
        return Double.longBitsToDouble(ByteKit.bytesToLongBE(data, off));
    }

    public static double bytesToDoubleLE(byte[] data, int off) {
        return Double.longBitsToDouble(ByteKit.bytesToLongLE(data, off));
    }

    public static byte[] shortToBytes(int data, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.shortToBytesBE(data, bytes, off) : ByteKit.shortToBytesLE(data, bytes, off);
    }

    public static byte[] shortToBytesBE(int data, byte[] bytes, int off) {
        bytes[off] = (byte)(data >> 8);
        bytes[off + 1] = (byte)data;
        return bytes;
    }

    public static byte[] shortToBytesLE(int data, byte[] bytes, int off) {
        bytes[off + 1] = (byte)(data >> 8);
        bytes[off] = (byte)data;
        return bytes;
    }

    public static byte[] intToBytes(int data, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.intToBytesBE(data, bytes, off) : ByteKit.intToBytesLE(data, bytes, off);
    }

    public static byte[] intToBytesBE(int data, byte[] bytes, int off) {
        bytes[off] = (byte)(data >> 24);
        bytes[off + 1] = (byte)(data >> 16);
        bytes[off + 2] = (byte)(data >> 8);
        bytes[off + 3] = (byte)data;
        return bytes;
    }

    public static byte[] intToBytesLE(int data, byte[] bytes, int off) {
        bytes[off + 3] = (byte)(data >> 24);
        bytes[off + 2] = (byte)(data >> 16);
        bytes[off + 1] = (byte)(data >> 8);
        bytes[off] = (byte)data;
        return bytes;
    }

    public static byte[] tagToBytes(int data, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.tagToBytesBE(data, bytes, off) : ByteKit.tagToBytesLE(data, bytes, off);
    }

    public static byte[] tagToBytesBE(int data, byte[] bytes, int off) {
        return ByteKit.intToBytesBE(data, bytes, off);
    }

    public static byte[] tagToBytesLE(int data, byte[] bytes, int off) {
        bytes[off + 1] = (byte)(data >> 24);
        bytes[off] = (byte)(data >> 16);
        bytes[off + 3] = (byte)(data >> 8);
        bytes[off + 2] = (byte)data;
        return bytes;
    }

    public static byte[] floatToBytes(float data, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.floatToBytesBE(data, bytes, off) : ByteKit.floatToBytesLE(data, bytes, off);
    }

    public static byte[] floatToBytesBE(float data, byte[] bytes, int off) {
        return ByteKit.intToBytesBE(Float.floatToIntBits(data), bytes, off);
    }

    public static byte[] floatToBytesLE(float data, byte[] bytes, int off) {
        return ByteKit.intToBytesLE(Float.floatToIntBits(data), bytes, off);
    }

    public static byte[] doubleToBytes(double data, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.doubleToBytesBE(data, bytes, off) : ByteKit.doubleToBytesLE(data, bytes, off);
    }

    public static byte[] doubleToBytesBE(double data, byte[] bytes, int off) {
        return ByteKit.longToBytesBE(Double.doubleToLongBits(data), bytes, off);
    }

    public static byte[] doubleToBytesLE(double data, byte[] bytes, int off) {
        return ByteKit.longToBytesLE(Double.doubleToLongBits(data), bytes, off);
    }

    public static byte[] longToBytes(long data, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.longToBytesBE(data, bytes, off) : ByteKit.longToBytesLE(data, bytes, off);
    }

    public static byte[] longToBytesBE(long data, byte[] bytes, int off) {
        bytes[off] = (byte)(data >> 56);
        bytes[off + 1] = (byte)(data >> 48);
        bytes[off + 2] = (byte)(data >> 40);
        bytes[off + 3] = (byte)(data >> 32);
        bytes[off + 4] = (byte)(data >> 24);
        bytes[off + 5] = (byte)(data >> 16);
        bytes[off + 6] = (byte)(data >> 8);
        bytes[off + 7] = (byte)data;
        return bytes;
    }

    public static byte[] longToBytesLE(long data, byte[] bytes, int off) {
        bytes[off + 7] = (byte)(data >> 56);
        bytes[off + 6] = (byte)(data >> 48);
        bytes[off + 5] = (byte)(data >> 40);
        bytes[off + 4] = (byte)(data >> 32);
        bytes[off + 3] = (byte)(data >> 24);
        bytes[off + 2] = (byte)(data >> 16);
        bytes[off + 1] = (byte)(data >> 8);
        bytes[off] = (byte)data;
        return bytes;
    }

    public static void bytesToShort(byte[] data, short[] s, int off, int len, boolean bigEndian) {
        if (bigEndian) {
            ByteKit.bytesToShortsBE(data, s, off, len);
        } else {
            ByteKit.bytesToShortLE(data, s, off, len);
        }
    }

    public static void bytesToShortsBE(byte[] data, short[] s, int off, int len) {
        int boff = 0;
        for (int j = 0; j < len; ++j) {
            byte b0 = data[boff];
            int b1 = data[boff + 1] & 0xFF;
            s[off + j] = (short)(b0 << 8 | b1);
            boff += 2;
        }
    }

    public static void bytesToShortLE(byte[] data, short[] s, int off, int len) {
        int boff = 0;
        for (int j = 0; j < len; ++j) {
            byte b0 = data[boff + 1];
            int b1 = data[boff] & 0xFF;
            s[off + j] = (short)(b0 << 8 | b1);
            boff += 2;
        }
    }

    public static byte[] swapInts(byte[] data, int off, int len) {
        ByteKit.checkLength(len, 4);
        int n = off + len;
        for (int i = off; i < n; i += 4) {
            ByteKit.swap(data, i, i + 3);
            ByteKit.swap(data, i + 1, i + 2);
        }
        return data;
    }

    public static byte[] swapLongs(byte[] data, int off, int len) {
        ByteKit.checkLength(len, 8);
        int n = off + len;
        for (int i = off; i < n; i += 8) {
            ByteKit.swap(data, i, i + 7);
            ByteKit.swap(data, i + 1, i + 6);
            ByteKit.swap(data, i + 2, i + 5);
            ByteKit.swap(data, i + 3, i + 4);
        }
        return data;
    }

    public static byte[][] swapShorts(byte[][] data) {
        int carry = 0;
        for (int i = 0; i < data.length; ++i) {
            byte[] b = data[i];
            if (carry != 0) {
                ByteKit.swapLastFirst(data[i - 1], b);
            }
            int len = b.length - carry;
            ByteKit.swapShorts(b, carry, len & 0xFFFFFFFE);
            carry = len & 1;
        }
        return data;
    }

    public static byte[] swapShorts(byte[] data, int off, int len) {
        ByteKit.checkLength(len, 2);
        int n = off + len;
        for (int i = off; i < n; i += 2) {
            ByteKit.swap(data, i, i + 1);
        }
        return data;
    }

    public static int indexOf(byte[] data, byte target, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (data[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int countOf(byte[] data, byte target) {
        int count = 0;
        for (byte b : data) {
            if (b != target) continue;
            ++count;
        }
        return count;
    }

    public static String bcd(byte[] data, int from, int to) {
        char[] chars = new char[2 * (to - from)];
        for (int i = from; i < to; ++i) {
            int b = ByteKit.unsigned(data[i]);
            chars[2 * (i - from)] = (char)((b >> 4) + 48);
            chars[2 * (i - from) + 1] = (char)((b & 0xF) + 48);
        }
        return new String(chars);
    }

    public static int unsigned(byte data) {
        if (data >= 0) {
            return data;
        }
        return 256 + data;
    }

    public static int xor(byte[] data) {
        int temp = 0;
        if (null != data) {
            for (int i = 0; i < data.length; ++i) {
                temp ^= data[i];
            }
        }
        return temp;
    }

    public static byte[] concat(byte[] buf1, byte[] buf2) {
        byte[] buffer = new byte[buf1.length + buf2.length];
        int offset = 0;
        System.arraycopy(buf1, 0, buffer, offset, buf1.length);
        System.arraycopy(buf2, 0, buffer, offset += buf1.length, buf2.length);
        return buffer;
    }

    private static void checkLength(int len, int numBytes) {
        if (len < 0 || len % numBytes != 0) {
            throw new IllegalArgumentException("length: " + len);
        }
    }

    private static void swap(byte[] data, int a, int b) {
        byte t = data[a];
        data[a] = data[b];
        data[b] = t;
    }

    private static void swapLastFirst(byte[] b1, byte[] b2) {
        int last = b1.length - 1;
        byte t = b2[0];
        b2[0] = b1[last];
        b1[last] = t;
    }
}

