/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.aoju.bus.core.collection.CopiedIter;
import org.aoju.bus.core.collection.EnumerationIter;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.Func;
import org.aoju.bus.core.lang.Matcher;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class IterKit {
    public static boolean isEmpty(Iterable<?> iterable) {
        return null == iterable || IterKit.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return null == iterator || false == iterator.hasNext();
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return null != iterable && IterKit.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return null != iterator && iterator.hasNext();
    }

    public static boolean isEqualList(Iterable<?> list1, Iterable<?> list2) {
        if (list1 == list2) {
            return true;
        }
        Iterator<?> it1 = list1.iterator();
        Iterator<?> it2 = list2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Object obj2;
            Object obj1 = it1.next();
            if (Objects.equals(obj1, obj2 = it2.next())) continue;
            return false;
        }
        return false == (it1.hasNext() || it2.hasNext());
    }

    public static boolean hasNull(Iterable<?> iterable) {
        return IterKit.hasNull(null == iterable ? null : iterable.iterator());
    }

    public static boolean hasNull(Iterator<?> iterator) {
        if (null == iterator) {
            return true;
        }
        while (iterator.hasNext()) {
            if (null != iterator.next()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Iterable<?> iterable) {
        return IterKit.isAllNull(null == iterable ? null : iterable.iterator());
    }

    public static boolean isAllNull(Iterator<?> iterator) {
        return null == IterKit.getFirstNoneNull(iterator);
    }

    public static <T> Map<T, Integer> countMap(Iterable<T> iterable) {
        return IterKit.countMap(null == iterable ? null : iterable.iterator());
    }

    public static <T> Map<T, Integer> countMap(Iterator<T> iterator) {
        HashMap<T, Integer> countMap = new HashMap<T, Integer>();
        if (null != iterator) {
            while (iterator.hasNext()) {
                T t = iterator.next();
                countMap.put(t, countMap.getOrDefault(t, 0) + 1);
            }
        }
        return countMap;
    }

    public static <K, V> Map<K, V> fieldValueMap(Iterable<V> iterable, String fieldName) {
        return IterKit.fieldValueMap(null == iterable ? null : iterable.iterator(), fieldName);
    }

    public static <K, V> Map<K, V> fieldValueMap(Iterator<V> iterator, String fieldName) {
        HashMap<Object, V> result = new HashMap<Object, V>();
        if (null != iterator) {
            while (iterator.hasNext()) {
                V value = iterator.next();
                result.put(ReflectKit.getFieldValue(value, fieldName), value);
            }
        }
        return result;
    }

    public static <K, V> Map<K, V> fieldValueAsMap(Iterator<?> iterator, String fieldNameForKey, String fieldNameForValue) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (null != iterator) {
            while (iterator.hasNext()) {
                Object value = iterator.next();
                result.put(ReflectKit.getFieldValue(value, fieldNameForKey), ReflectKit.getFieldValue(value, fieldNameForValue));
            }
        }
        return result;
    }

    public static <V> List<Object> fieldValueList(Iterator<V> iterator, String fieldName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (null != iterator) {
            while (iterator.hasNext()) {
                V value = iterator.next();
                result.add(ReflectKit.getFieldValue(value, fieldName));
            }
        }
        return result;
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        if (null == iterable) {
            return null;
        }
        return IterKit.join(iterable.iterator(), conjunction);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction, String prefix, String suffix) {
        if (null == iterable) {
            return null;
        }
        return IterKit.join(iterable.iterator(), conjunction, prefix, suffix);
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        return IterKit.join(iterator, conjunction, null, null);
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction, String prefix, String suffix) {
        return IterKit.join(iterator, conjunction, item -> {
            if (ArrayKit.isArray(item)) {
                return ArrayKit.join(ArrayKit.wrap(item), conjunction, prefix, suffix);
            }
            if (item instanceof Iterable) {
                return IterKit.join((Iterable)item, conjunction, prefix, suffix);
            }
            if (item instanceof Iterator) {
                return IterKit.join((Iterator)item, conjunction, prefix, suffix);
            }
            return StringKit.wrap(String.valueOf(item), prefix, suffix);
        });
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction, Function<T, ? extends CharSequence> func) {
        if (null == iterator) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (iterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            T item = iterator.next();
            sb.append(func.apply(item));
        }
        return sb.toString();
    }

    public static <K, V> HashMap<K, V> toMap(Iterable<Map.Entry<K, V>> entryIter) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (IterKit.isNotEmpty(entryIter)) {
            for (Map.Entry<K, V> entry : entryIter) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values) {
        return IterKit.toMap(keys, values, false);
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values, boolean isOrder) {
        return IterKit.toMap(null == keys ? null : keys.iterator(), null == values ? null : values.iterator(), isOrder);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values) {
        return IterKit.toMap(keys, values, false);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values, boolean isOrder) {
        HashMap<K, Object> resultMap = MapKit.newHashMap(isOrder);
        if (IterKit.isNotEmpty(keys)) {
            while (keys.hasNext()) {
                resultMap.put(keys.next(), null != values && values.hasNext() ? (Object)values.next() : null);
            }
        }
        return resultMap;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        return IterKit.toListMap(iterable, keyMapper, v -> v);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return IterKit.toListMap(MapKit.newHashMap(), iterable, keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Map<K, List<V>> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapKit.newHashMap();
        }
        if (ObjectKit.isNull(iterable)) {
            return resultMap;
        }
        for (T value : iterable) {
            resultMap.computeIfAbsent(keyMapper.apply(value), k -> new ArrayList()).add(valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <K, V> Map<K, V> toMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        return IterKit.toMap(iterable, keyMapper, (T v) -> v);
    }

    public static <T, K, V> Map<K, V> toMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return IterKit.toMap(MapKit.newHashMap(), iterable, keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, V> toMap(Map<K, V> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapKit.newHashMap();
        }
        if (ObjectKit.isNull(iterable)) {
            return resultMap;
        }
        for (T value : iterable) {
            resultMap.put(keyMapper.apply(value), valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <E> List<E> toList(Iterable<E> iterable) {
        if (null == iterable) {
            return null;
        }
        return IterKit.toList(iterable.iterator());
    }

    public static <E> List<E> toList(Iterator<E> iterator) {
        ArrayList<E> list = new ArrayList<E>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return new EnumerationIter<E>(e);
    }

    public static <E> Iterable<E> asIterable(Iterator<E> iter) {
        return () -> iter;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (null == iterable) {
            return null;
        }
        return IterKit.getFirst(iterable.iterator());
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        if (null != iterator && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> T getFirstNoneNull(Iterable<T> iterable) {
        if (null == iterable) {
            return null;
        }
        return IterKit.getFirstNoneNull(iterable.iterator());
    }

    public static <T> T getFirstNoneNull(Iterator<T> iterator) {
        return (T)IterKit.getFirstNoneNull(iterator, Objects::nonNull);
    }

    public static <T> T getFirstNoneNull(Iterator<T> iterator, Matcher<T> matcher) {
        Assert.notNull(matcher, "Matcher must be not null !", new Object[0]);
        if (null != iterator) {
            while (iterator.hasNext()) {
                T next = iterator.next();
                if (!matcher.match(next)) continue;
                return next;
            }
        }
        return null;
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        if (null != iterable) {
            Iterator<?> iterator = iterable.iterator();
            return IterKit.getElementType(iterator);
        }
        return null;
    }

    public static Class<?> getElementType(Iterator<?> iterator) {
        Object t;
        CopiedIter iter2 = new CopiedIter(iterator);
        if (iter2.hasNext() && null != (t = iter2.next())) {
            return t.getClass();
        }
        return null;
    }

    public static <T extends Iterable<E>, E> T filter(T iterable, Filter<E> filter) {
        if (null == iterable) {
            return null;
        }
        IterKit.filter(iterable.iterator(), filter);
        return iterable;
    }

    public static <E> Iterator<E> filter(Iterator<E> iterator, Filter<E> filter) {
        if (null == iterator || null == filter) {
            return iterator;
        }
        while (iterator.hasNext()) {
            if (filter.accept(iterator.next())) continue;
            iterator.remove();
        }
        return iterator;
    }

    public static <K, V> Map<K, V> toMap(Iterator<V> iterator, Map<K, V> map, Func.Func1<V, K> keyFunc) {
        return IterKit.toMap(iterator, map, keyFunc, (E value) -> value);
    }

    public static <K, V, E> Map<K, V> toMap(Iterator<E> iterator, Map<K, V> map, Func.Func1<E, K> keyFunc, Func.Func1<E, V> valueFunc) {
        if (null == iterator) {
            return map;
        }
        if (null == map) {
            map = MapKit.newHashMap(true);
        }
        while (iterator.hasNext()) {
            E element = iterator.next();
            try {
                map.put(keyFunc.call(element), valueFunc.call(element));
            }
            catch (Exception e) {
                throw new InstrumentException(e);
            }
        }
        return map;
    }

    public static <T> Iterator<T> empty() {
        return Collections.emptyIterator();
    }

    public static int size(Iterable<?> iterable) {
        if (null == iterable) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        return IterKit.size(iterable.iterator());
    }

    public static int size(Iterator<?> iterator) {
        int size = 0;
        if (null != iterator) {
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
        }
        return size;
    }
}

