/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import org.aoju.bus.core.io.watchers.WatchMonitor;
import org.aoju.bus.core.io.watchers.Watcher;
import org.aoju.bus.core.toolkit.UriKit;

public class WatchKit {
    public static WatchMonitor create(URL url, WatchEvent.Kind<?> ... events) {
        return WatchKit.create(url, 0, events);
    }

    public static WatchMonitor create(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchKit.create(UriKit.toURI(url), maxDepth, events);
    }

    public static WatchMonitor create(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchKit.create(uri, 0, events);
    }

    public static WatchMonitor create(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchKit.create(Paths.get(uri), maxDepth, events);
    }

    public static WatchMonitor create(File file, WatchEvent.Kind<?> ... events) {
        return WatchKit.create(file, 0, events);
    }

    public static WatchMonitor create(File file, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchKit.create(file.toPath(), maxDepth, events);
    }

    public static WatchMonitor create(String path, WatchEvent.Kind<?> ... events) {
        return WatchKit.create(path, 0, events);
    }

    public static WatchMonitor create(String path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchKit.create(Paths.get(path, new String[0]), maxDepth, events);
    }

    public static WatchMonitor create(Path path, WatchEvent.Kind<?> ... events) {
        return WatchKit.create(path, 0, events);
    }

    public static WatchMonitor create(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, maxDepth, events);
    }

    public static WatchMonitor createAll(URL url, Watcher watcher) {
        return WatchKit.createAll(url, 0, watcher);
    }

    public static WatchMonitor createAll(URL url, int maxDepth, Watcher watcher) {
        return WatchKit.createAll(UriKit.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor createAll(URI uri, Watcher watcher) {
        return WatchKit.createAll(uri, 0, watcher);
    }

    public static WatchMonitor createAll(URI uri, int maxDepth, Watcher watcher) {
        return WatchKit.createAll(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor createAll(File file, Watcher watcher) {
        return WatchKit.createAll(file, 0, watcher);
    }

    public static WatchMonitor createAll(File file, int maxDepth, Watcher watcher) {
        return WatchKit.createAll(file.toPath(), 0, watcher);
    }

    public static WatchMonitor createAll(String path, Watcher watcher) {
        return WatchKit.createAll(path, 0, watcher);
    }

    public static WatchMonitor createAll(String path, int maxDepth, Watcher watcher) {
        return WatchKit.createAll(Paths.get(path, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor createAll(Path path, Watcher watcher) {
        return WatchKit.createAll(path, 0, watcher);
    }

    public static WatchMonitor createAll(Path path, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchKit.create(path, maxDepth, WatchMonitor.EVENTS_ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public static WatchMonitor createModify(URL url, Watcher watcher) {
        return WatchKit.createModify(url, 0, watcher);
    }

    public static WatchMonitor createModify(URL url, int maxDepth, Watcher watcher) {
        return WatchKit.createModify(UriKit.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor createModify(URI uri, Watcher watcher) {
        return WatchKit.createModify(uri, 0, watcher);
    }

    public static WatchMonitor createModify(URI uri, int maxDepth, Watcher watcher) {
        return WatchKit.createModify(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor createModify(File file, Watcher watcher) {
        return WatchKit.createModify(file, 0, watcher);
    }

    public static WatchMonitor createModify(File file, int maxDepth, Watcher watcher) {
        return WatchKit.createModify(file.toPath(), 0, watcher);
    }

    public static WatchMonitor createModify(String path, Watcher watcher) {
        return WatchKit.createModify(path, 0, watcher);
    }

    public static WatchMonitor createModify(String path, int maxDepth, Watcher watcher) {
        return WatchKit.createModify(Paths.get(path, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor createModify(Path path, Watcher watcher) {
        return WatchKit.createModify(path, 0, watcher);
    }

    public static WatchMonitor createModify(Path path, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchKit.create(path, maxDepth, WatchMonitor.ENTRY_MODIFY);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }
}

