/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.digest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.digest.mac.MacEngine;
import org.aoju.bus.crypto.digest.mac.MacEngineFactory;

public class HMac
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MacEngine engine;

    public HMac(String algorithm) {
        this(algorithm, (Key)null);
    }

    public HMac(String algorithm, byte[] key) {
        this(algorithm, new SecretKeySpec(key, algorithm));
    }

    public HMac(String algorithm, Key key) {
        this(MacEngineFactory.createEngine(algorithm, key));
    }

    public HMac(MacEngine engine) {
        this.engine = engine;
    }

    public byte[] digest(String data, String charset) {
        return this.digest(StringKit.bytes((CharSequence)data, charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, "UTF-8");
    }

    public String digestHex(String data, String charset) {
        return HexKit.encodeHexStr(this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws InstrumentException {
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream(file);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        finally {
            IoKit.close(in);
        }
    }

    public String digestHex(File file) {
        return HexKit.encodeHexStr(this.digest(file));
    }

    public byte[] digest(byte[] data) {
        return this.digest(new ByteArrayInputStream(data), -1);
    }

    public String digestHex(byte[] data) {
        return HexKit.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 8192);
    }

    public String digestHex(InputStream data) {
        return HexKit.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        return this.engine.digest(data, bufferLength);
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexKit.encodeHexStr(this.digest(data, bufferLength));
    }

    public int getMacLength() {
        return this.engine.getMacLength();
    }

    public String getAlgorithm() {
        return this.engine.getAlgorithm();
    }

    public boolean verify(byte[] digest, byte[] digestToCompare) {
        return MessageDigest.isEqual(digest, digestToCompare);
    }

    public MacEngine getEngine() {
        return this.engine;
    }
}

