/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.digest.mac;

import java.security.Key;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.digest.mac.MacEngine;

public class DefaultHMacEngine
implements MacEngine {
    private Mac mac;

    public DefaultHMacEngine(String algorithm, byte[] key) {
        this.init(algorithm, key);
    }

    public DefaultHMacEngine(String algorithm, Key key) {
        this.init(algorithm, key);
    }

    public DefaultHMacEngine init(String algorithm, byte[] key) {
        return this.init(algorithm, null == key ? null : new SecretKeySpec(key, algorithm));
    }

    public DefaultHMacEngine init(String algorithm, Key key) {
        try {
            this.mac = Builder.createMac(algorithm);
            if (null == key) {
                key = Builder.generateKey(algorithm);
            }
            this.mac.init(key);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        return this;
    }

    public Mac getMac() {
        return this.mac;
    }

    @Override
    public void update(byte[] in) {
        this.mac.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.mac.update(in, inOff, len);
    }

    @Override
    public byte[] doFinal() {
        return this.mac.doFinal();
    }

    @Override
    public void reset() {
        this.mac.reset();
    }

    @Override
    public int getMacLength() {
        return this.mac.getMacLength();
    }

    @Override
    public String getAlgorithm() {
        return this.mac.getAlgorithm();
    }
}

