/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.digest.otp;

import java.time.Duration;
import java.time.Instant;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.digest.otp.HOTP;

public class TOTP
extends HOTP {
    public static final Duration DEFAULT_TIME_STEP = Duration.ofSeconds(30L);
    private final Duration timeStep;

    public TOTP(byte[] key) {
        this(DEFAULT_TIME_STEP, key);
    }

    public TOTP(Duration timeStep, byte[] key) {
        this(timeStep, 6, key);
    }

    public TOTP(Duration timeStep, int passwordLength, byte[] key) {
        this(timeStep, passwordLength, "HmacSHA1", key);
    }

    public TOTP(Duration timeStep, int passwordLength, String algorithm, byte[] key) {
        super(passwordLength, algorithm, key);
        this.timeStep = timeStep;
    }

    public static String generateGoogleSecretKey(String account, int numBytes) {
        return StringKit.format("otpauth://totp/{}?secret={}", account, TOTP.generateSecretKey(numBytes));
    }

    public int generate(Instant timestamp) {
        return this.generate(timestamp.toEpochMilli() / this.timeStep.toMillis());
    }

    public boolean validate(Instant timestamp, int offsetSize, int code) {
        if (offsetSize == 0) {
            return this.generate(timestamp) == code;
        }
        for (int i = -offsetSize; i <= offsetSize; ++i) {
            if (this.generate(timestamp.plus(this.getTimeStep().multipliedBy(i))) != code) continue;
            return true;
        }
        return false;
    }

    public Duration getTimeStep() {
        return this.timeStep;
    }
}

