/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.Padding;

public class Symmetric
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SecretKey secretKey;
    private Cipher cipher;
    private AlgorithmParameterSpec params;
    private boolean isZeroPadding;
    private Lock lock = new ReentrantLock();

    public Symmetric(String algorithm) {
        this(algorithm, (byte[])null);
    }

    public Symmetric(String algorithm, byte[] key) {
        this(algorithm, Builder.generateKey(algorithm, key));
    }

    public Symmetric(String algorithm, SecretKey key) {
        this(algorithm, key, null);
    }

    public Symmetric(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        this.init(algorithm, key);
        if (null != paramsSpec) {
            this.setParams(paramsSpec);
        }
    }

    public Symmetric init(String algorithm, SecretKey key) {
        Assert.notBlank(algorithm, "'algorithm' must be not blank !", new Object[0]);
        this.secretKey = key;
        if (algorithm.startsWith("PBE")) {
            this.params = new PBEParameterSpec(RandomKit.randomBytes(8), 100);
        }
        if (algorithm.contains(Padding.ZeroPadding.name())) {
            algorithm = StringKit.replace(algorithm, Padding.ZeroPadding.name(), Padding.NoPadding.name());
            this.isZeroPadding = true;
        }
        this.cipher = Builder.createCipher(algorithm);
        return this;
    }

    public Symmetric setParams(AlgorithmParameterSpec params) {
        this.params = params;
        return this;
    }

    public Symmetric setIv(IvParameterSpec iv) {
        this.setParams(iv);
        return this;
    }

    public Symmetric setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }

    public byte[] encrypt(byte[] data) {
        this.lock.lock();
        try {
            Cipher cipher = this.initCipher(1);
            byte[] byArray = cipher.doFinal(this.paddingDataWithZero(data, cipher.getBlockSize()));
            return byArray;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void encrypt(InputStream data, OutputStream out, boolean isClose) throws InstrumentException {
        this.lock.lock();
        CipherOutputStream cipherOutputStream = null;
        try {
            int remainLength;
            int blockSize;
            Cipher cipher = this.initCipher(1);
            cipherOutputStream = new CipherOutputStream(out, cipher);
            long length = IoKit.copy(data, cipherOutputStream);
            if (this.isZeroPadding && (blockSize = cipher.getBlockSize()) > 0 && (remainLength = (int)(length % (long)blockSize)) > 0) {
                cipherOutputStream.write(new byte[blockSize - remainLength]);
                cipherOutputStream.flush();
            }
        }
        catch (InstrumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            this.lock.unlock();
            if (isClose) {
                IoKit.close(data);
                IoKit.close(cipherOutputStream);
            }
        }
    }

    public String encryptHex(byte[] data) {
        return HexKit.encodeHexStr(this.encrypt(data));
    }

    public String encryptBase64(byte[] data) {
        return Base64.encode(this.encrypt(data));
    }

    public byte[] encrypt(String data, String charset) {
        return this.encrypt(StringKit.bytes((CharSequence)data, charset));
    }

    public byte[] encrypt(String data, java.nio.charset.Charset charset) {
        return this.encrypt(StringKit.bytes((CharSequence)data, charset));
    }

    public String encryptHex(String data, String charset) {
        return HexKit.encodeHexStr(this.encrypt(data, charset));
    }

    public String encryptHex(String data, java.nio.charset.Charset charset) {
        return HexKit.encodeHexStr(this.encrypt(data, charset));
    }

    public String encryptBase64(String data, String charset) {
        return Base64.encode(this.encrypt(data, charset));
    }

    public String encryptBase64(String data, java.nio.charset.Charset charset) {
        return Base64.encode(this.encrypt(data, charset));
    }

    public byte[] encrypt(String data) {
        return this.encrypt(StringKit.bytes((CharSequence)data, Charset.UTF_8));
    }

    public String encryptHex(String data) {
        return HexKit.encodeHexStr(this.encrypt(data));
    }

    public String encryptBase64(String data) {
        return Base64.encode(this.encrypt(data));
    }

    public byte[] encrypt(InputStream data) throws InstrumentException {
        return this.encrypt(IoKit.readBytes(data));
    }

    public String encryptHex(InputStream data) {
        return HexKit.encodeHexStr(this.encrypt(data));
    }

    public String encryptBase64(InputStream data) {
        return Base64.encode(this.encrypt(data));
    }

    public byte[] decrypt(byte[] bytes) {
        byte[] decryptData;
        int blockSize;
        this.lock.lock();
        try {
            if (null == this.params) {
                this.cipher.init(2, this.secretKey);
            } else {
                this.cipher.init(2, (Key)this.secretKey, this.params);
            }
            blockSize = this.cipher.getBlockSize();
            decryptData = this.cipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            this.lock.unlock();
        }
        return this.removePadding(decryptData, blockSize);
    }

    public String decryptStr(byte[] bytes, java.nio.charset.Charset charset) {
        return StringKit.toString(this.decrypt(bytes), charset);
    }

    public String decryptStr(byte[] bytes) {
        return this.decryptStr(bytes, Charset.UTF_8);
    }

    public byte[] decrypt(String data) {
        return this.decrypt(Builder.decode(data));
    }

    public String decryptStr(String data, java.nio.charset.Charset charset) {
        return StringKit.toString(this.decrypt(data), charset);
    }

    public String decryptStr(String data) {
        return this.decryptStr(data, Charset.UTF_8);
    }

    public byte[] decrypt(InputStream data) throws InstrumentException {
        return this.decrypt(IoKit.readBytes(data));
    }

    public String decryptStr(InputStream data, java.nio.charset.Charset charset) {
        return StringKit.toString(this.decrypt(data), charset);
    }

    public String decryptStr(InputStream data) {
        return this.decryptStr(data, Charset.UTF_8);
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public byte[] update(byte[] data) {
        this.lock.lock();
        try {
            Cipher cipher = this.initCipher(1);
            byte[] byArray = cipher.update(this.paddingDataWithZero(data, cipher.getBlockSize()));
            return byArray;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String updateHex(byte[] data) {
        return HexKit.encodeHexStr(this.update(data));
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    private Cipher initCipher(int mode) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = this.cipher;
        if (null == this.params) {
            cipher.init(mode, this.secretKey);
        } else {
            cipher.init(mode, (Key)this.secretKey, this.params);
        }
        return cipher;
    }

    private byte[] paddingDataWithZero(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) > 0) {
            return ArrayKit.resize(data, length + blockSize - remainLength);
        }
        return data;
    }

    private byte[] removePadding(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            return ArrayKit.resize(data, i + 1);
        }
        return data;
    }
}

