/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.filter;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Mode;
import org.aoju.bus.crypto.Padding;
import org.aoju.bus.crypto.symmetric.AES;
import org.aoju.bus.crypto.symmetric.Symmetric;
import org.aoju.bus.goalie.Config;
import org.aoju.bus.goalie.Context;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483647)
public class DecryptFilter
implements WebFilter {
    private final Config.Decrypt decrypt;
    private Symmetric symmetric;

    public DecryptFilter(Config.Decrypt decrypt) {
        this.decrypt = decrypt;
    }

    @PostConstruct
    public void init() {
        if ("AES".equals(this.decrypt.getType())) {
            this.symmetric = new AES(Mode.CBC, Padding.PKCS7Padding, this.decrypt.getKey().getBytes(), this.decrypt.getOffset().getBytes());
        }
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerWebExchange.Builder builder = exchange.mutate();
        if (this.decrypt.isEnabled() && Context.get(exchange).isNeedDecrypt()) {
            this.doDecrypt(Context.get(exchange).getRequestMap());
        }
        return chain.filter(builder.build());
    }

    private void doDecrypt(Map<String, String> map) {
        if (null == this.symmetric) {
            return;
        }
        map.forEach((k, v) -> {
            if (StringKit.isNotBlank(v)) {
                map.put((String)k, this.symmetric.decryptStr((String)v, Charset.UTF_8));
            }
        });
    }
}

