/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.hardware;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractNetworkIF;
import org.aoju.bus.health.builtin.hardware.NetworkIF;
import org.aoju.bus.health.unix.aix.drivers.perfstat.PerfstatNetInterface;

@ThreadSafe
public final class AixNetworkIF
extends AbstractNetworkIF {
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long speed;
    private long timeStamp;
    private Supplier<Perfstat.perfstat_netinterface_t[]> netstats;

    public AixNetworkIF(NetworkInterface netint, Supplier<Perfstat.perfstat_netinterface_t[]> netstats) {
        super(netint);
        this.netstats = netstats;
        this.updateAttributes();
    }

    public static List<NetworkIF> getNetworks(boolean includeLocalInterfaces) {
        Supplier<Perfstat.perfstat_netinterface_t[]> netstats = Memoize.memoize(PerfstatNetInterface::queryNetInterfaces, Memoize.defaultExpiration());
        ArrayList<NetworkIF> ifList = new ArrayList<NetworkIF>();
        for (NetworkInterface ni : AixNetworkIF.getNetworkInterfaces(includeLocalInterfaces)) {
            ifList.add(new AixNetworkIF(ni, netstats));
        }
        return ifList;
    }

    @Override
    public long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public long getInErrors() {
        return this.inErrors;
    }

    @Override
    public long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public long getInDrops() {
        return this.inDrops;
    }

    @Override
    public long getCollisions() {
        return this.collisions;
    }

    @Override
    public long getSpeed() {
        return this.speed;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean updateAttributes() {
        Perfstat.perfstat_netinterface_t[] stats = this.netstats.get();
        long now = System.currentTimeMillis();
        for (Perfstat.perfstat_netinterface_t stat : stats) {
            String name = Native.toString((byte[])stat.name);
            if (!name.equals(this.getName())) continue;
            this.bytesSent = stat.obytes;
            this.bytesRecv = stat.ibytes;
            this.packetsSent = stat.opackets;
            this.packetsRecv = stat.ipackets;
            this.outErrors = stat.oerrors;
            this.inErrors = stat.ierrors;
            this.collisions = stat.collisions;
            this.inDrops = stat.if_iqdrops;
            this.speed = stat.bitrate;
            this.timeStamp = now;
            return true;
        }
        return false;
    }
}

