/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.software;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.software.AbstractInternetProtocolStats;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;
import org.aoju.bus.health.unix.aix.drivers.perfstat.PerfstatProtocol;

@ThreadSafe
public class AixInternetProtocolStats
extends AbstractInternetProtocolStats {
    private Supplier<Perfstat.perfstat_protocol_t[]> ipstats = Memoize.memoize(PerfstatProtocol::queryProtocols, Memoize.defaultExpiration());

    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        for (Perfstat.perfstat_protocol_t stat : this.ipstats.get()) {
            if (!"tcp".equals(Native.toString((byte[])stat.name))) continue;
            return new InternetProtocolStats.TcpStats(stat.u.tcp.established, stat.u.tcp.initiated, stat.u.tcp.accepted, stat.u.tcp.dropped, stat.u.tcp.dropped, stat.u.tcp.opackets, stat.u.tcp.ipackets, 0L, stat.u.tcp.ierrors, 0L);
        }
        return new InternetProtocolStats.TcpStats(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        for (Perfstat.perfstat_protocol_t stat : this.ipstats.get()) {
            if (!"udp".equals(Native.toString((byte[])stat.name))) continue;
            return new InternetProtocolStats.UdpStats(stat.u.udp.opackets, stat.u.udp.ipackets, stat.u.udp.no_socket, stat.u.udp.ierrors);
        }
        return new InternetProtocolStats.UdpStats(0L, 0L, 0L, 0L);
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        return new InternetProtocolStats.UdpStats(0L, 0L, 0L, 0L);
    }
}

