/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.software;

import java.util.List;
import java.util.Map;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractOSThread;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.unix.aix.software.AixOSProcess;

public class AixOSThread
extends AbstractOSThread {
    private int threadId;
    private OSProcess.State state = OSProcess.State.INVALID;
    private long contextSwitches;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private int priority;

    public AixOSThread(int pid, Map<AixOSProcess.PsThreadColumns, String> threadMap) {
        super(pid);
        this.updateAttributes(threadMap);
    }

    @Override
    public int getThreadId() {
        return this.threadId;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean updateAttributes() {
        List<String> threadListInfoPs = Executor.runNative("ps -m -o THREAD -p " + this.getOwningProcessId());
        if (threadListInfoPs.size() > 2) {
            threadListInfoPs.remove(0);
            threadListInfoPs.remove(0);
            String tidStr = Integer.toString(this.getThreadId());
            for (String threadInfo : threadListInfoPs) {
                Map<AixOSProcess.PsThreadColumns, String> threadMap = Builder.stringToEnumMap(AixOSProcess.PsThreadColumns.class, threadInfo.trim(), ' ');
                if (!threadMap.containsKey((Object)AixOSProcess.PsThreadColumns.COMMAND) || !tidStr.equals(threadMap.get((Object)AixOSProcess.PsThreadColumns.TID))) continue;
                return this.updateAttributes(threadMap);
            }
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    private boolean updateAttributes(Map<AixOSProcess.PsThreadColumns, String> threadMap) {
        this.threadId = Builder.parseIntOrDefault(threadMap.get((Object)AixOSProcess.PsThreadColumns.TID), 0);
        this.state = AixOSProcess.getStateFromOutput(threadMap.get((Object)AixOSProcess.PsThreadColumns.ST).charAt(0));
        this.priority = Builder.parseIntOrDefault(threadMap.get((Object)AixOSProcess.PsThreadColumns.PRI), 0);
        return true;
    }
}

