/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Formats;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class KstatKit {
    private static final LibKstat KS = LibKstat.INSTANCE;
    private static final LibKstat.KstatCtl KC = KS.kstat_open();
    private static final ReentrantLock CHAIN = new ReentrantLock();

    private KstatKit() {
    }

    public static KstatChain openChain() {
        return new KstatChain();
    }

    public static String dataLookupString(LibKstat.Kstat ksp, String name) {
        if (ksp.ks_type != 1 && ksp.ks_type != 4) {
            throw new IllegalArgumentException("Not a kstat_named or kstat_timer kstat.");
        }
        Pointer p = KS.kstat_data_lookup(ksp, name);
        if (null == p) {
            Logger.debug("Failed lo lookup kstat value for key {}", name);
            return "";
        }
        LibKstat.KstatNamed data = new LibKstat.KstatNamed(p);
        switch (data.data_type) {
            case 0: {
                return Native.toString((byte[])data.value.charc, (java.nio.charset.Charset)Charset.UTF_8);
            }
            case 1: {
                return Integer.toString(data.value.i32);
            }
            case 2: {
                return Formats.toUnsignedString(data.value.ui32);
            }
            case 3: {
                return Long.toString(data.value.i64);
            }
            case 4: {
                return Formats.toUnsignedString(data.value.ui64);
            }
            case 9: {
                return data.value.str.addr.getString(0L);
            }
        }
        Logger.error("Unimplemented kstat data type {}", data.data_type);
        return "";
    }

    public static long dataLookupLong(LibKstat.Kstat ksp, String name) {
        if (ksp.ks_type != 1 && ksp.ks_type != 4) {
            throw new IllegalArgumentException("Not a kstat_named or kstat_timer kstat.");
        }
        Pointer p = KS.kstat_data_lookup(ksp, name);
        if (null == p) {
            if (Logger.get().isError()) {
                Logger.error("Failed lo lookup kstat value on {}:{}:{} for key {}", Native.toString((byte[])ksp.ks_module, (java.nio.charset.Charset)Charset.US_ASCII), ksp.ks_instance, Native.toString((byte[])ksp.ks_name, (java.nio.charset.Charset)Charset.US_ASCII), name);
            }
            return 0L;
        }
        LibKstat.KstatNamed data = new LibKstat.KstatNamed(p);
        switch (data.data_type) {
            case 1: {
                return data.value.i32;
            }
            case 2: {
                return Formats.getUnsignedInt(data.value.ui32);
            }
            case 3: {
                return data.value.i64;
            }
            case 4: {
                return data.value.ui64;
            }
        }
        Logger.error("Unimplemented or non-numeric kstat data type {}", data.data_type);
        return 0L;
    }

    public static final class KstatChain
    implements AutoCloseable {
        private KstatChain() {
            CHAIN.lock();
            KstatChain.update();
        }

        public static boolean read(LibKstat.Kstat ksp) {
            int retry = 0;
            while (0 > KS.kstat_read(KC, ksp, null)) {
                if (11 != Native.getLastError() || 5 <= ++retry) {
                    if (Logger.get().isDebug()) {
                        Logger.debug("Failed to read kstat {}:{}:{}", Native.toString((byte[])ksp.ks_module, (java.nio.charset.Charset)Charset.US_ASCII), ksp.ks_instance, Native.toString((byte[])ksp.ks_name, (java.nio.charset.Charset)Charset.US_ASCII));
                    }
                    return false;
                }
                Builder.sleep(8 << retry);
            }
            return true;
        }

        public static LibKstat.Kstat lookup(String module, int instance, String name) {
            return KS.kstat_lookup(KC, module, instance, name);
        }

        public static List<LibKstat.Kstat> lookupAll(String module, int instance, String name) {
            ArrayList<LibKstat.Kstat> kstats = new ArrayList<LibKstat.Kstat>();
            for (LibKstat.Kstat ksp = KS.kstat_lookup(KC, module, instance, name); null != ksp; ksp = ksp.next()) {
                if (null != module && !module.equals(Native.toString((byte[])ksp.ks_module, (java.nio.charset.Charset)Charset.US_ASCII)) || instance >= 0 && instance != ksp.ks_instance || null != name && !name.equals(Native.toString((byte[])ksp.ks_name, (java.nio.charset.Charset)Charset.US_ASCII))) continue;
                kstats.add(ksp);
            }
            return kstats;
        }

        public static int update() {
            return KS.kstat_chain_update(KC);
        }

        @Override
        public void close() {
            CHAIN.unlock();
        }
    }
}

