/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.drivers;

import com.sun.jna.Native;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.health.builtin.software.OSSession;
import org.aoju.bus.health.unix.solaris.SolarisLibc;

@ThreadSafe
public final class Who {
    private static final SolarisLibc LIBC = SolarisLibc.INSTANCE;

    private Who() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized List<OSSession> queryUtxent() {
        ArrayList<OSSession> whoList = new ArrayList<OSSession>();
        LIBC.setutxent();
        try {
            SolarisLibc.SolarisUtmpx ut;
            while (null != (ut = LIBC.getutxent())) {
                String user;
                if (ut.ut_type != 7 && ut.ut_type != 6 || "LOGIN".equals(user = Native.toString((byte[])ut.ut_user, (java.nio.charset.Charset)Charset.US_ASCII))) continue;
                String device = Native.toString((byte[])ut.ut_line, (java.nio.charset.Charset)Charset.US_ASCII);
                String host = Native.toString((byte[])ut.ut_host, (java.nio.charset.Charset)Charset.US_ASCII);
                long loginTime = ut.ut_tv.tv_sec.longValue() * 1000L + ut.ut_tv.tv_usec.longValue() / 1000L;
                if (user.isEmpty() || device.isEmpty() || loginTime < 0L || loginTime > System.currentTimeMillis()) {
                    List<OSSession> list = org.aoju.bus.health.unix.Who.queryWho();
                    return list;
                }
                whoList.add(new OSSession(user, device, loginTime, host));
            }
            return whoList;
        }
        finally {
            LIBC.endutxent();
        }
    }
}

