/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.software;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.software.AbstractOSProcess;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.builtin.software.OSThread;
import org.aoju.bus.health.unix.solaris.drivers.PsInfo;
import org.aoju.bus.health.unix.solaris.software.SolarisOSThread;
import org.aoju.bus.health.unix.solaris.software.SolarisOperatingSystem;

@ThreadSafe
public class SolarisOSProcess
extends AbstractOSProcess {
    static final String PS_THREAD_COLUMNS = Arrays.stream(PsThreadColumns.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(","));
    private Supplier<Pair<List<String>, Map<String, String>>> cmdEnv = Memoize.memoize(this::queryCommandlineEnvironment);
    private Supplier<Integer> bitness = Memoize.memoize(this::queryBitness);
    private String commandLineBackup;
    private Supplier<String> commandLine = Memoize.memoize(this::queryCommandLine);
    private String name;
    private String path = "";
    private long contextSwitches = 0L;
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;

    public SolarisOSProcess(int pid, Map<SolarisOperatingSystem.PsKeywords, String> psMap, Map<SolarisOperatingSystem.PrstatKeywords, String> prstatMap) {
        super(pid);
        this.updateAttributes(psMap, prstatMap);
    }

    @Override
    public String getCommandLine() {
        return this.commandLine.get();
    }

    static Map<Integer, String[]> parseAndMergeThreadInfo(List<String> psThreadInfo, List<String> prstatThreadInfo) {
        HashMap<Integer, String[]> map = new HashMap<Integer, String[]>();
        String[] mergedSplit = new String[9];
        if (psThreadInfo.size() > 1) {
            psThreadInfo.stream().skip(1L).forEach(threadInfo -> {
                String[] psSplit = RegEx.SPACES.split(threadInfo.trim());
                if (psSplit.length == 7) {
                    for (int idx = 0; idx < psSplit.length; ++idx) {
                        if (idx == 0) {
                            map.put(Builder.parseIntOrDefault(psSplit[idx], 0), mergedSplit);
                        }
                        mergedSplit[idx] = psSplit[idx];
                    }
                }
            });
            if (prstatThreadInfo.size() > 1) {
                prstatThreadInfo.stream().skip(1L).forEach(threadInfo -> {
                    String threadId;
                    String[] existingSplit;
                    int idxAfterForwardSlash;
                    String[] splitPrstat = RegEx.SPACES.split(threadInfo.trim());
                    if (splitPrstat.length == 15 && (idxAfterForwardSlash = splitPrstat[14].lastIndexOf(47) + 1) > 0 && idxAfterForwardSlash < splitPrstat[14].length() && null != (existingSplit = (String[])map.get(Integer.parseInt(threadId = splitPrstat[14].substring(idxAfterForwardSlash))))) {
                        existingSplit[7] = splitPrstat[10];
                        existingSplit[8] = splitPrstat[11];
                    }
                });
            }
        }
        return map;
    }

    static OSProcess.State getStateFromOutput(char stateValue) {
        OSProcess.State state;
        switch (stateValue) {
            case 'O': {
                state = OSProcess.State.RUNNING;
                break;
            }
            case 'S': {
                state = OSProcess.State.SLEEPING;
                break;
            }
            case 'R': 
            case 'W': {
                state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                state = OSProcess.State.OTHER;
            }
        }
        return state;
    }

    static Map<Integer, String[]> parseAndMergePSandPrstatInfo(List<String> psInfo, int psKeyIndex, int psLength, List<String> prstatInfo, boolean useTid) {
        HashMap<Integer, String[]> map = new HashMap<Integer, String[]>();
        if (psInfo.size() > 1) {
            psInfo.stream().skip(1L).forEach(info -> {
                String[] psSplit = RegEx.SPACES.split(info.trim(), psLength);
                String[] mergedSplit = new String[psLength + 2];
                if (psSplit.length == psLength) {
                    for (int idx = 0; idx < psLength; ++idx) {
                        if (idx == psKeyIndex) {
                            map.put(Builder.parseIntOrDefault(psSplit[idx], 0), mergedSplit);
                        }
                        mergedSplit[idx] = psSplit[idx];
                    }
                }
            });
            if (prstatInfo.size() > 1) {
                prstatInfo.stream().skip(1L).forEach(threadInfo -> {
                    String[] splitPrstat = RegEx.SPACES.split(threadInfo.trim());
                    if (splitPrstat.length == 15) {
                        String[] existingSplit;
                        int idxAfterForwardSlash;
                        String id = splitPrstat[0];
                        if (useTid && (idxAfterForwardSlash = splitPrstat[14].lastIndexOf(47) + 1) > 0 && idxAfterForwardSlash < splitPrstat[14].length()) {
                            id = splitPrstat[14].substring(idxAfterForwardSlash);
                        }
                        if ((existingSplit = (String[])map.get(Integer.parseInt(id))) != null) {
                            existingSplit[psLength] = splitPrstat[10];
                            existingSplit[psLength + 1] = splitPrstat[11];
                        }
                    }
                });
            }
        }
        return map;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    private String queryCommandLine() {
        String cl = String.join((CharSequence)" ", this.getArguments());
        return cl.isEmpty() ? this.commandLineBackup : cl;
    }

    @Override
    public List<String> getArguments() {
        return this.cmdEnv.get().getLeft();
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.cmdEnv.get().getRight();
    }

    private Pair<List<String>, Map<String, String>> queryCommandlineEnvironment() {
        return PsInfo.queryArgsEnv(this.getProcessID());
    }

    @Override
    public List<OSThread> getThreadDetails() {
        ArrayList<OSThread> threads = new ArrayList<OSThread>();
        List<String> threadList = Executor.runNative("ps -o " + PS_THREAD_COLUMNS + " -p " + this.getProcessID());
        if (threadList.size() > 1) {
            List<String> prstatList = Executor.runNative("prstat -L -v -p " + this.getProcessID() + " 1 1");
            HashMap<String, String> prstatRowMap = new HashMap<String, String>();
            for (String s : prstatList) {
                String row = s.trim();
                int idx = row.lastIndexOf(47);
                if (idx <= 0) continue;
                prstatRowMap.put(row.substring(idx + 1), row);
            }
            threadList.remove(0);
            for (String thread : threadList) {
                Map<PsThreadColumns, String> psMap = Builder.stringToEnumMap(PsThreadColumns.class, thread.trim(), ' ');
                if (!psMap.containsKey((Object)PsThreadColumns.PRI)) continue;
                String lwpStr = psMap.get((Object)PsThreadColumns.LWP);
                Map<SolarisOperatingSystem.PrstatKeywords, String> prstatMap = Builder.stringToEnumMap(SolarisOperatingSystem.PrstatKeywords.class, prstatRowMap.getOrDefault(lwpStr, ""), ' ');
                threads.add(new SolarisOSThread(this.getProcessID(), psMap, prstatMap));
            }
        }
        return threads;
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return Builder.getCwd(this.getProcessID());
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getVirtualSize() {
        return this.virtualSize;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long getOpenFiles() {
        return Builder.getOpenFiles(this.getProcessID());
    }

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    private int queryBitness() {
        List<String> pflags = Executor.runNative("pflags " + this.getProcessID());
        for (String line : pflags) {
            if (!line.contains("data model")) continue;
            if (line.contains("LP32")) {
                return 32;
            }
            if (!line.contains("LP64")) continue;
            return 64;
        }
        return 0;
    }

    @Override
    public long getAffinityMask() {
        long bitMask = 0L;
        String cpuset = Executor.getFirstAnswer("pbind -q " + this.getProcessID());
        if (cpuset.isEmpty()) {
            List<String> allProcs = Executor.runNative("psrinfo");
            for (String proc : allProcs) {
                String[] split = RegEx.SPACES.split(proc);
                int bitToSet = Builder.parseIntOrDefault(split[0], -1);
                if (bitToSet < 0) continue;
                bitMask |= 1L << bitToSet;
            }
            return bitMask;
        }
        if (cpuset.endsWith(".") && cpuset.contains("strongly bound to processor(s)")) {
            int bitToSet;
            String parse = cpuset.substring(0, cpuset.length() - 1);
            String[] split = RegEx.SPACES.split(parse);
            for (int i = split.length - 1; i >= 0 && (bitToSet = Builder.parseIntOrDefault(split[i], -1)) >= 0; --i) {
                bitMask |= 1L << bitToSet;
            }
        }
        return bitMask;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public boolean updateAttributes() {
        Map<SolarisOperatingSystem.PsKeywords, String> psMap;
        int pid = this.getProcessID();
        List<String> procList = Executor.runNative("ps -o " + SolarisOperatingSystem.PS_COMMAND_ARGS + " -p " + pid);
        if (procList.size() > 1 && (psMap = Builder.stringToEnumMap(SolarisOperatingSystem.PsKeywords.class, procList.get(1).trim(), ' ')).containsKey((Object)SolarisOperatingSystem.PsKeywords.ARGS)) {
            String pidStr = psMap.get((Object)SolarisOperatingSystem.PsKeywords.PID);
            List<String> prstatList = Executor.runNative("prstat -v -p " + pidStr + " 1 1");
            String prstatRow = "";
            for (String s : prstatList) {
                String row = s.trim();
                if (!row.startsWith(pidStr + " ")) continue;
                prstatRow = row;
                break;
            }
            Map<SolarisOperatingSystem.PrstatKeywords, String> prstatMap = Builder.stringToEnumMap(SolarisOperatingSystem.PrstatKeywords.class, prstatRow, ' ');
            return this.updateAttributes(psMap, prstatMap);
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    private boolean updateAttributes(Map<SolarisOperatingSystem.PsKeywords, String> psMap, Map<SolarisOperatingSystem.PrstatKeywords, String> prstatMap) {
        long now = System.currentTimeMillis();
        this.state = SolarisOSProcess.getStateFromOutput(psMap.get((Object)SolarisOperatingSystem.PsKeywords.S).charAt(0));
        this.parentProcessID = Builder.parseIntOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.PPID), 0);
        this.user = psMap.get((Object)SolarisOperatingSystem.PsKeywords.USER);
        this.userID = psMap.get((Object)SolarisOperatingSystem.PsKeywords.UID);
        this.group = psMap.get((Object)SolarisOperatingSystem.PsKeywords.GROUP);
        this.groupID = psMap.get((Object)SolarisOperatingSystem.PsKeywords.GID);
        this.threadCount = Builder.parseIntOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.NLWP), 0);
        this.priority = Builder.parseIntOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.PRI), 0);
        this.virtualSize = Builder.parseLongOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.VSZ), 0L) * 1024L;
        this.residentSetSize = Builder.parseLongOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.RSS), 0L) * 1024L;
        long elapsedTime = Builder.parseDHMSOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.ETIME), 0L);
        this.upTime = elapsedTime < 1L ? 1L : elapsedTime;
        this.startTime = now - this.upTime;
        this.kernelTime = 0L;
        this.userTime = Builder.parseDHMSOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.TIME), 0L);
        this.path = psMap.get((Object)SolarisOperatingSystem.PsKeywords.COMM);
        this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
        this.commandLineBackup = psMap.get((Object)SolarisOperatingSystem.PsKeywords.ARGS);
        if (prstatMap.containsKey((Object)SolarisOperatingSystem.PrstatKeywords.ICX)) {
            long nonVoluntaryContextSwitches = Builder.parseLongOrDefault(prstatMap.get((Object)SolarisOperatingSystem.PrstatKeywords.ICX), 0L);
            long voluntaryContextSwitches = Builder.parseLongOrDefault(prstatMap.get((Object)SolarisOperatingSystem.PrstatKeywords.VCX), 0L);
            this.contextSwitches = voluntaryContextSwitches + nonVoluntaryContextSwitches;
        }
        return true;
    }

    static enum PsThreadColumns {
        LWP,
        S,
        ETIME,
        TIME,
        ADDR,
        PRI;

    }
}

