/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.aoju.bus.image.nimble.codec.BytesWithImageDescriptor;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;

final class ExtMemoryOutputStream
extends MemoryCacheImageOutputStream
implements BytesWithImageDescriptor {
    private final ExtFilterOutputStream stream;
    private final ImageDescriptor imageDescriptor;

    public ExtMemoryOutputStream(ImageDescriptor imageDescriptor) {
        this(new ExtFilterOutputStream(), imageDescriptor);
    }

    private ExtMemoryOutputStream(ExtFilterOutputStream stream, ImageDescriptor imageDescriptor) {
        super(stream);
        this.stream = stream;
        this.imageDescriptor = imageDescriptor;
    }

    public void setOutputStream(OutputStream stream) {
        this.stream.setOutputStream(stream);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    @Override
    public ByteBuffer getBytes() throws IOException {
        int read;
        byte[] array = new byte[8192];
        int length = 0;
        while ((read = this.read(array, length, array.length - length)) > 0) {
            if ((length += read) != array.length) continue;
            array = Arrays.copyOf(array, array.length << 1);
        }
        return ByteBuffer.wrap(array, 0, length);
    }

    @Override
    public void flushBefore(long pos) throws IOException {
        if (null != this.stream.getOutputStream()) {
            super.flushBefore(pos);
        }
    }

    private static final class ExtFilterOutputStream
    extends FilterOutputStream {
        public ExtFilterOutputStream() {
            super(null);
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }
    }
}

