/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.entity;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class EntityField {
    private String name;
    private Field field;
    private Class<?> javaType;
    private Method setter;
    private Method getter;

    public EntityField(Field field, PropertyDescriptor propertyDescriptor) {
        if (null != field) {
            this.field = field;
            this.name = field.getName();
            this.javaType = field.getType();
        }
        if (null != propertyDescriptor) {
            this.name = propertyDescriptor.getName();
            this.setter = propertyDescriptor.getWriteMethod();
            this.getter = propertyDescriptor.getReadMethod();
            this.javaType = propertyDescriptor.getPropertyType();
        }
    }

    public void copyFromPropertyDescriptor(EntityField other) {
        this.setter = other.setter;
        this.getter = other.getter;
        this.javaType = other.javaType;
        this.name = other.name;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        boolean result = false;
        if (null != this.field) {
            result = this.field.isAnnotationPresent(annotationClass);
        }
        if (!result && null != this.setter) {
            result = this.setter.isAnnotationPresent(annotationClass);
        }
        if (!result && null != this.getter) {
            result = this.getter.isAnnotationPresent(annotationClass);
        }
        return result;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T result = null;
        if (null != this.field) {
            result = this.field.getAnnotation(annotationClass);
        }
        if (null == result && null != this.setter) {
            result = this.setter.getAnnotation(annotationClass);
        }
        if (null == result && null != this.getter) {
            result = this.getter.getAnnotation(annotationClass);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        EntityField that = (EntityField)o;
        return !(null == this.name ? null != that.name : !this.name.equals(that.name));
    }

    public int hashCode() {
        return null != this.name ? this.name.hashCode() : 0;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public String getName() {
        return this.name;
    }
}

