/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class TwitterProvider
extends AbstractProvider {
    private static final String PREAMBLE = "OAuth";

    public TwitterProvider(Context context) {
        super(context, Registry.TWITTER);
    }

    public TwitterProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.TOUTIAO, extendCache);
    }

    private static String generateNonce(int len) {
        String s = "0123456789QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm";
        Random rng = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int index = rng.nextInt(62);
            sb.append(s, index, index + 1);
        }
        return sb.toString();
    }

    private static String sign(Map<String, String> params, String method, String baseUrl, String apiSecret, String tokenSecret) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<String, String> e : params.entrySet()) {
            map.put(UriKit.encode(e.getKey()), e.getValue());
        }
        String str = Builder.parseMapToString(map, true);
        String baseStr = method.toUpperCase() + "&" + UriKit.encode(baseUrl) + "&" + UriKit.encode(str);
        String signKey = apiSecret + "&" + (StringKit.isEmpty(tokenSecret) ? "" : tokenSecret);
        byte[] signature = TwitterProvider.sign(signKey.getBytes(Charset.DEFAULT), baseStr.getBytes(Charset.DEFAULT), "HmacSHA1");
        return new String(Base64.encode(signature, false));
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        Map<String, String> oauthParams = this.buildOauthParams();
        oauthParams.put("oauth_token", callback.getOauthToken());
        oauthParams.put("oauth_verifier", callback.getOauthVerifier());
        oauthParams.put("oauth_signature", TwitterProvider.sign(oauthParams, "POST", this.source.accessToken(), this.context.getAppSecret(), callback.getOauthToken()));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", this.buildHeader(oauthParams));
        header.put("Content-Type", "application/x-www-form-urlencoded");
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("oauth_verifier", callback.getOauthVerifier());
        String response = Httpx.post(this.source.accessToken(), queryMap, header);
        Map<String, String> requestToken = this.parseStringToMap(response, false);
        return AccToken.builder().oauthToken(requestToken.get("oauth_token")).oauthTokenSecret(requestToken.get("oauth_token_secret")).userId(requestToken.get("user_id")).screenName(requestToken.get("screen_name")).build();
    }

    @Override
    public String authorize(String state) {
        AccToken token = this.getRequestToken();
        return Builder.fromUrl(this.source.authorize()).queryParam("oauth_token", token.getOauthToken()).build();
    }

    @Override
    public String userInfoUrl(AccToken authToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("include_entities", true).queryParam("include_email", true).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        HashMap<String, String> queryParams = new HashMap<String, String>(5);
        queryParams.put("include_entities", Boolean.toString(true));
        queryParams.put("include_email", Boolean.toString(true));
        Map<String, String> oauthParams = this.buildOauthParams();
        oauthParams.put("oauth_token", accToken.getOauthToken());
        HashMap<String, String> params = new HashMap<String, String>(oauthParams);
        params.putAll(queryParams);
        oauthParams.put("oauth_signature", TwitterProvider.sign(params, "GET", this.source.userInfo(), this.context.getAppSecret(), accToken.getOauthTokenSecret()));
        String header = this.buildHeader(oauthParams);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Authorization", header);
        String response = Httpx.get(this.userInfoUrl(accToken), null, map);
        JSONObject object = JSONObject.parseObject((String)response);
        return Property.builder().rawJson(object).uuid(object.getString("id_str")).username(object.getString("screen_name")).nickname(object.getString("name")).remark(object.getString("description")).avatar(object.getString("profile_image_url_https")).email(object.getString("email")).blog(object.getString("url")).location(object.getString("location")).source(this.source.toString()).token(accToken).build();
    }

    private Map<String, String> buildOauthParams() {
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("oauth_consumer_key", this.context.getAppKey());
        params.put("oauth_nonce", TwitterProvider.generateNonce(32));
        params.put("oauth_signature_method", "HMAC-SHA1");
        params.put("oauth_timestamp", "" + DateKit.timestamp());
        params.put("oauth_version", "1.0");
        return params;
    }

    private String buildHeader(Map<String, String> params) {
        StringBuilder sb = new StringBuilder("OAuth ");
        for (Map.Entry<String, String> param : params.entrySet()) {
            sb.append(param.getKey()).append("=\"").append(UriKit.encode(param.getValue())).append('\"').append(", ");
        }
        return sb.deleteCharAt(sb.length() - 2).toString();
    }

    private AccToken getRequestToken() {
        String baseUrl = "https://api.twitter.com/oauth/request_token";
        Map<String, String> oauthParams = this.buildOauthParams();
        oauthParams.put("oauth_callback", this.context.getRedirectUri());
        oauthParams.put("oauth_signature", TwitterProvider.sign(oauthParams, "POST", baseUrl, this.context.getAppSecret(), null));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", this.buildHeader(oauthParams));
        String requestToken = Httpx.post(baseUrl, null, header);
        Map<String, String> res = this.parseStringToMap(requestToken, false);
        return AccToken.builder().oauthToken(res.get("oauth_token")).oauthTokenSecret(res.get("oauth_token_secret")).oauthCallbackConfirmed(Boolean.valueOf(res.get("oauth_callback_confirmed"))).build();
    }
}

