/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.proxy;

import java.util.Properties;
import org.aoju.bus.pager.Page;
import org.aoju.bus.pager.PageContext;
import org.aoju.bus.pager.Paging;
import org.aoju.bus.pager.RowBounds;
import org.aoju.bus.pager.plugin.PageFromObject;

public class PageParams {
    protected boolean offsetAsPageNo = false;
    protected boolean rowBoundsWithCount = false;
    protected boolean pageSizeZero = false;
    protected boolean reasonable = false;
    protected boolean supportMethodsArguments = false;
    protected String countColumn = "0";

    public Page getPage(Object parameterObject, org.apache.ibatis.session.RowBounds rowBounds) {
        Page<Object> page = PageContext.getLocalPage();
        if (null == page) {
            if (rowBounds != org.apache.ibatis.session.RowBounds.DEFAULT) {
                if (this.offsetAsPageNo) {
                    page = new Page(rowBounds.getOffset(), rowBounds.getLimit(), this.rowBoundsWithCount);
                } else {
                    page = new Page(new int[]{rowBounds.getOffset(), rowBounds.getLimit()}, this.rowBoundsWithCount);
                    page.setReasonable(false);
                }
                if (rowBounds instanceof RowBounds) {
                    RowBounds pageRowBounds = (RowBounds)rowBounds;
                    page.setCount(null == pageRowBounds.getCount() || pageRowBounds.getCount() != false);
                }
            } else if (parameterObject instanceof Paging || this.supportMethodsArguments) {
                try {
                    page = PageFromObject.getPageFromObject(parameterObject, false);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (null == page) {
                return null;
            }
            PageContext.setLocalPage(page);
        }
        if (null == page.getReasonable()) {
            page.setReasonable(this.reasonable);
        }
        if (null == page.getPageSizeZero()) {
            page.setPageSizeZero(this.pageSizeZero);
        }
        return page;
    }

    public void setProperties(Properties properties) {
        String offsetAsPageNo = properties.getProperty("offsetAsPageNo");
        this.offsetAsPageNo = Boolean.parseBoolean(offsetAsPageNo);
        String rowBoundsWithCount = properties.getProperty("rowBoundsWithCount");
        this.rowBoundsWithCount = Boolean.parseBoolean(rowBoundsWithCount);
        String pageSizeZero = properties.getProperty("pageSizeZero");
        this.pageSizeZero = Boolean.parseBoolean(pageSizeZero);
        String reasonable = properties.getProperty("reasonable");
        this.reasonable = Boolean.parseBoolean(reasonable);
        String supportMethodsArguments = properties.getProperty("supportMethodsArguments");
        this.supportMethodsArguments = Boolean.parseBoolean(supportMethodsArguments);
        String countColumn = properties.getProperty("countColumn");
        if (PageFromObject.isNotEmpty(countColumn)) {
            this.countColumn = countColumn;
        }
        PageFromObject.setParams(properties.getProperty("params"));
    }

    public boolean isOffsetAsPageNo() {
        return this.offsetAsPageNo;
    }

    public boolean isRowBoundsWithCount() {
        return this.rowBoundsWithCount;
    }

    public boolean isPageSizeZero() {
        return this.pageSizeZero;
    }

    public boolean isReasonable() {
        return this.reasonable;
    }

    public boolean isSupportMethodsArguments() {
        return this.supportMethodsArguments;
    }

    public String getCountColumn() {
        return this.countColumn;
    }
}

