/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.channel;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.ReadPendingException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ShutdownChannelGroupException;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritePendingException;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.socket.channel.AsynchronousChannelGroup;
import org.aoju.bus.socket.handler.FutureCompletionHandler;

public class AsynchronousSocketChannel
extends java.nio.channels.AsynchronousSocketChannel {
    private final SocketChannel channel;
    private final AsynchronousChannelGroup group;
    private final AsynchronousChannelGroup.Worker readWorker;
    private final AsynchronousChannelGroup.Worker writeWorker;
    private ByteBuffer readBuffer;
    private ByteBufferArray scatteringReadBuffer;
    private ByteBuffer writeBuffer;
    private ByteBufferArray gatheringWriteBuffer;
    private CompletionHandler<Number, Object> readCompletionHandler;
    private CompletionHandler<Number, Object> writeCompletionHandler;
    private CompletionHandler<Void, Object> connectCompletionHandler;
    private FutureCompletionHandler<Void, Void> connectFuture;
    private FutureCompletionHandler<? extends Number, Object> readFuture;
    private FutureCompletionHandler<? extends Number, Object> writeFuture;
    private Object readAttachment;
    private Object writeAttachment;
    private Object connectAttachment;
    private SelectionKey readSelectionKey;
    private SelectionKey writeSelectionKey;
    private boolean writePending;
    private boolean readPending;
    private boolean connectionPending;
    private SocketAddress remote;

    public AsynchronousSocketChannel(AsynchronousChannelGroup group, SocketChannel channel) throws IOException {
        super(group.provider());
        this.group = group;
        this.channel = channel;
        this.readWorker = group.getReadWorker();
        this.writeWorker = group.getWriteWorker();
        channel.configureBlocking(false);
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        try {
            this.channel.close();
        }
        catch (IOException e) {
            exception = e;
        }
        if (null != this.readSelectionKey) {
            this.readSelectionKey.cancel();
        }
        if (null != this.writeSelectionKey) {
            this.writeSelectionKey.cancel();
        }
        if (null != exception) {
            throw exception;
        }
    }

    @Override
    public java.nio.channels.AsynchronousSocketChannel bind(SocketAddress local) throws IOException {
        this.channel.bind(local);
        return this;
    }

    @Override
    public <T> java.nio.channels.AsynchronousSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        this.channel.setOption((SocketOption)name, (Object)value);
        return this;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.channel.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.channel.supportedOptions();
    }

    @Override
    public java.nio.channels.AsynchronousSocketChannel shutdownInput() throws IOException {
        this.channel.shutdownInput();
        return this;
    }

    @Override
    public java.nio.channels.AsynchronousSocketChannel shutdownOutput() throws IOException {
        this.channel.shutdownOutput();
        return this;
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.channel.getRemoteAddress();
    }

    @Override
    public <A> void connect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        if (this.group.isTerminated()) {
            throw new ShutdownChannelGroupException();
        }
        if (this.channel.isConnected()) {
            throw new AlreadyConnectedException();
        }
        if (this.connectionPending) {
            throw new ConnectionPendingException();
        }
        this.connectionPending = true;
        this.connectAttachment = attachment;
        this.connectCompletionHandler = handler;
        this.remote = remote;
        this.doConnect();
    }

    @Override
    public Future<Void> connect(SocketAddress remote) {
        FutureCompletionHandler connectFuture = new FutureCompletionHandler();
        this.connect(remote, null, connectFuture);
        this.connectFuture = connectFuture;
        return connectFuture;
    }

    @Override
    public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.read0(dst, null, timeout, unit, attachment, handler);
    }

    private <V extends Number, A> void read0(ByteBuffer readBuffer, ByteBufferArray scattering, long timeout, TimeUnit unit, A attachment, CompletionHandler<V, ? super A> handler) {
        if (!this.channel.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (this.readPending) {
            throw new ReadPendingException();
        }
        this.readPending = true;
        this.readBuffer = readBuffer;
        this.scatteringReadBuffer = scattering;
        this.readAttachment = attachment;
        if (timeout > 0L) {
            this.readFuture = new FutureCompletionHandler<V, Object>(handler, this.readAttachment);
            this.readCompletionHandler = this.readFuture;
            this.group.getScheduledExecutor().schedule(this.readFuture, timeout, unit);
        } else {
            this.readCompletionHandler = handler;
        }
        this.doRead();
    }

    @Override
    public Future<Integer> read(ByteBuffer readBuffer) {
        FutureCompletionHandler readFuture = new FutureCompletionHandler();
        this.read(readBuffer, 0L, TimeUnit.MILLISECONDS, null, readFuture);
        this.readFuture = readFuture;
        return readFuture;
    }

    @Override
    public <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        this.read0(null, new ByteBufferArray(dsts, offset, length), timeout, unit, attachment, handler);
    }

    @Override
    public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.write0(src, null, timeout, unit, attachment, handler);
    }

    private <V extends Number, A> void write0(ByteBuffer writeBuffer, ByteBufferArray gathering, long timeout, TimeUnit unit, A attachment, CompletionHandler<V, ? super A> handler) {
        if (!this.channel.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (this.writePending) {
            throw new WritePendingException();
        }
        this.writePending = true;
        this.writeBuffer = writeBuffer;
        this.gatheringWriteBuffer = gathering;
        this.writeAttachment = attachment;
        if (timeout > 0L) {
            this.writeFuture = new FutureCompletionHandler<V, Object>(handler, this.writeAttachment);
            this.writeCompletionHandler = this.writeFuture;
            this.group.getScheduledExecutor().schedule(this.writeFuture, timeout, unit);
        } else {
            this.writeCompletionHandler = handler;
        }
        this.doWrite();
    }

    @Override
    public Future<Integer> write(ByteBuffer src) {
        FutureCompletionHandler writeFuture = new FutureCompletionHandler();
        this.write0(src, null, 0L, TimeUnit.MILLISECONDS, null, writeFuture);
        this.writeFuture = writeFuture;
        return writeFuture;
    }

    @Override
    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        this.write0(null, new ByteBufferArray(srcs, offset, length), timeout, unit, attachment, handler);
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.channel.getLocalAddress();
    }

    public void doConnect() {
        block6: {
            try {
                if (null != this.connectFuture && this.connectFuture.isDone()) {
                    this.resetConnect();
                    return;
                }
                boolean connected = this.channel.isConnectionPending();
                if (connected || this.channel.connect(this.remote)) {
                    connected = this.channel.finishConnect();
                }
                if (connected) {
                    CompletionHandler<Void, Object> completionHandler = this.connectCompletionHandler;
                    Object attach = this.connectAttachment;
                    this.resetConnect();
                    completionHandler.completed(null, attach);
                    break block6;
                }
                if (null == this.writeSelectionKey) {
                    this.writeWorker.addRegister(selector -> {
                        try {
                            this.writeSelectionKey = this.channel.register(selector, 8);
                            this.writeSelectionKey.attach(this);
                        }
                        catch (ClosedChannelException e) {
                            this.writeCompletionHandler.failed(e, this.writeAttachment);
                        }
                    });
                    break block6;
                }
                throw new IOException("unKnow exception");
            }
            catch (IOException e) {
                this.connectCompletionHandler.failed(e, this.connectAttachment);
            }
        }
    }

    private void resetConnect() {
        this.connectionPending = false;
        this.connectFuture = null;
        this.connectAttachment = null;
        this.connectCompletionHandler = null;
    }

    public void doRead() {
        try {
            if (null != this.readFuture && this.readFuture.isDone()) {
                this.group.removeOps(this.readSelectionKey, 1);
                this.resetRead();
                return;
            }
            boolean directRead = Thread.currentThread() == this.readWorker.getWorkerThread() && this.readWorker.invoker++ < 8;
            long readSize = 0L;
            boolean hasRemain = true;
            if (directRead) {
                if (null != this.scatteringReadBuffer) {
                    readSize = this.channel.read(this.scatteringReadBuffer.getBuffers(), this.scatteringReadBuffer.getOffset(), this.scatteringReadBuffer.getLength());
                    hasRemain = this.hasRemaining(this.scatteringReadBuffer);
                } else {
                    readSize = this.channel.read(this.readBuffer);
                    hasRemain = this.readBuffer.hasRemaining();
                }
            }
            if (readSize != 0L || !hasRemain) {
                CompletionHandler<Number, Object> completionHandler = this.readCompletionHandler;
                Object attach = this.readAttachment;
                ByteBufferArray scattering = this.scatteringReadBuffer;
                this.resetRead();
                if (null == scattering) {
                    completionHandler.completed((int)readSize, attach);
                } else {
                    completionHandler.completed(readSize, attach);
                }
                if (!this.readPending && null != this.readSelectionKey) {
                    this.group.removeOps(this.readSelectionKey, 1);
                }
            } else if (null == this.readSelectionKey) {
                this.readWorker.addRegister(selector -> {
                    try {
                        this.readSelectionKey = this.channel.register(selector, 1);
                        this.readSelectionKey.attach(this);
                    }
                    catch (ClosedChannelException e) {
                        this.readCompletionHandler.failed(e, this.readAttachment);
                    }
                });
            } else {
                this.group.interestOps(this.readWorker, this.readSelectionKey, 1);
            }
        }
        catch (IOException e) {
            this.readCompletionHandler.failed(e, this.readAttachment);
        }
    }

    private void resetRead() {
        this.readPending = false;
        this.readFuture = null;
        this.readCompletionHandler = null;
        this.readAttachment = null;
        this.readBuffer = null;
        this.scatteringReadBuffer = null;
    }

    public void doWrite() {
        try {
            if (null != this.writeFuture && this.writeFuture.isDone()) {
                this.resetWrite();
                return;
            }
            boolean directWrite = this.writeWorker.getWorkerThread() != Thread.currentThread() || this.writeWorker.invoker++ < 8;
            long writeSize = 0L;
            boolean hasRemain = true;
            if (directWrite) {
                if (null != this.gatheringWriteBuffer) {
                    writeSize = this.channel.write(this.gatheringWriteBuffer.getBuffers(), this.gatheringWriteBuffer.getOffset(), this.gatheringWriteBuffer.getLength());
                    hasRemain = this.hasRemaining(this.gatheringWriteBuffer);
                } else {
                    writeSize = this.channel.write(this.writeBuffer);
                    hasRemain = this.writeBuffer.hasRemaining();
                }
            }
            if (writeSize != 0L || !hasRemain) {
                CompletionHandler<Number, Object> completionHandler = this.writeCompletionHandler;
                Object attach = this.writeAttachment;
                ByteBufferArray scattering = this.gatheringWriteBuffer;
                this.resetWrite();
                if (null == scattering) {
                    completionHandler.completed((int)writeSize, attach);
                } else {
                    completionHandler.completed(writeSize, attach);
                }
            } else if (null == this.writeSelectionKey) {
                this.writeWorker.addRegister(selector -> {
                    try {
                        this.writeSelectionKey = this.channel.register(selector, 4);
                        this.writeSelectionKey.attach(this);
                    }
                    catch (ClosedChannelException e) {
                        this.writeCompletionHandler.failed(e, this.writeAttachment);
                    }
                });
            } else {
                this.group.interestOps(this.writeWorker, this.writeSelectionKey, 4);
            }
        }
        catch (IOException e) {
            this.writeCompletionHandler.failed(e, this.writeAttachment);
        }
    }

    private boolean hasRemaining(ByteBufferArray scattering) {
        for (int i = 0; i < scattering.getLength(); ++i) {
            if (!scattering.getBuffers()[scattering.getOffset() + i].hasRemaining()) continue;
            return true;
        }
        return false;
    }

    private void resetWrite() {
        this.writePending = false;
        this.writeFuture = null;
        this.writeAttachment = null;
        this.writeCompletionHandler = null;
        this.writeBuffer = null;
        this.gatheringWriteBuffer = null;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    final class ByteBufferArray {
        private final ByteBuffer[] buffers;
        private final int offset;
        private final int length;

        public ByteBufferArray(ByteBuffer[] buffers, int offset, int length) {
            this.buffers = buffers;
            this.offset = offset;
            this.length = length;
        }

        public ByteBuffer[] getBuffers() {
            return this.buffers;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }
    }
}

