/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Types;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.SpringHolder;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ResolvableType;
import org.springframework.stereotype.Component;

@Component
public class SpringBuilder {
    private static ConfigurableApplicationContext context;

    public static ConfigurableApplicationContext getContext() {
        return context;
    }

    public static void setContext(ConfigurableApplicationContext context) {
        Assert.notNull(context, "Could not found context for spring.", new Object[0]);
        SpringBuilder.context = context;
        SpringHolder.alive = true;
    }

    public static ListableBeanFactory getBeanFactory() {
        return null == context.getBeanFactory() ? context : context.getBeanFactory();
    }

    public static <T> T getBean(String name) {
        return (T)SpringBuilder.getBeanFactory().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringBuilder.getBeanFactory().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringBuilder.getBeanFactory().getBean(name, clazz);
    }

    public static <T> T getBean(Types<T> reference) {
        ParameterizedType parameterizedType = (ParameterizedType)reference.getType();
        Class rawType = (Class)parameterizedType.getRawType();
        Class[] genericTypes = (Class[])Arrays.stream(parameterizedType.getActualTypeArguments()).map(type -> (Class)type).toArray(Class[]::new);
        String[] beanNames = SpringBuilder.getBeanFactory().getBeanNamesForType(ResolvableType.forClassWithGenerics((Class)rawType, (Class[])genericTypes));
        return SpringBuilder.getBean(beanNames[0], rawType);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        return SpringBuilder.getBeanFactory().getBeansOfType(type);
    }

    public static String[] getBeanNamesForType(Class<?> type) {
        return SpringBuilder.getBeanFactory().getBeanNamesForType(type);
    }

    public static String getProperty(String key) {
        if (null == context) {
            return null;
        }
        return context.getEnvironment().getProperty(key);
    }

    public static String[] getActiveProfiles() {
        if (null == context) {
            return null;
        }
        return context.getEnvironment().getActiveProfiles();
    }

    public static String getActiveProfile() {
        String[] activeProfiles = SpringBuilder.getActiveProfiles();
        return ArrayKit.isNotEmpty(activeProfiles) ? activeProfiles[0] : null;
    }

    public static void registerBeanDefinition(Class clazz) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)SpringBuilder.getBeanFactory();
        beanFactory.registerBeanDefinition(StringKit.lowerFirst(clazz.getSimpleName()), (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition((Class)clazz).getBeanDefinition());
    }

    public static void registerSingleton(Class clazz) {
        try {
            SpringBuilder.registerSingleton(clazz, clazz.newInstance());
        }
        catch (InstantiationException e) {
            Logger.error(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            Logger.error(e.getMessage(), e);
        }
    }

    public static void registerSingleton(Class clazz, Object bean) {
        ConfigurableListableBeanFactory factory = (ConfigurableListableBeanFactory)SpringBuilder.getBeanFactory();
        factory.autowireBean(bean);
        factory.registerSingleton(StringKit.lowerFirst(clazz.getSimpleName()), bean);
    }

    public static void unRegisterSingleton(String beanName) {
        ConfigurableListableBeanFactory factory = (ConfigurableListableBeanFactory)SpringBuilder.getBeanFactory();
        if (!(factory instanceof DefaultSingletonBeanRegistry)) {
            throw new InstrumentException("Can not unregister bean, the factory is not a DefaultSingletonBeanRegistry!");
        }
        DefaultSingletonBeanRegistry registry = (DefaultSingletonBeanRegistry)factory;
        registry.destroySingleton(beanName);
    }

    public static void refreshContext() {
        if (SpringHolder.alive) {
            context.refresh();
        }
    }

    public static void removeContext() {
        if (SpringHolder.alive) {
            context.close();
            context = null;
            SpringHolder.alive = false;
        }
    }

    class TimeZoneBuilder {
        @Value(value="${spring.jackson.date-format:yyyy-MM-dd HH:mm:ss}")
        private String pattern;

        TimeZoneBuilder() {
        }

        @Bean
        public Jackson2ObjectMapperBuilderCustomizer customizer() {
            return builder -> {
                builder.locale(Locale.CHINA);
                builder.timeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
                builder.simpleDateFormat(this.pattern);
                builder.modules(new Module[]{new JavaTimeModule()});
            };
        }

        class JavaTimeModule
        extends SimpleModule {
            JavaTimeModule() {
                super(PackageVersion.VERSION);
                this.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                this.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                this.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
                this.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                this.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                this.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
            }
        }
    }
}

