/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.goalie;

import java.util.List;
import java.util.function.BiFunction;
import org.aoju.bus.goalie.Athlete;
import org.aoju.bus.goalie.filter.AuthorizeFilter;
import org.aoju.bus.goalie.filter.DecryptFilter;
import org.aoju.bus.goalie.filter.EncryptFilter;
import org.aoju.bus.goalie.filter.FormatFilter;
import org.aoju.bus.goalie.filter.LimitFilter;
import org.aoju.bus.goalie.filter.PrimaryFilter;
import org.aoju.bus.goalie.handler.ApiRouterHandler;
import org.aoju.bus.goalie.handler.ApiWebMvcRegistrations;
import org.aoju.bus.goalie.handler.GlobalExceptionHandler;
import org.aoju.bus.goalie.metric.Authorize;
import org.aoju.bus.goalie.registry.AssetsRegistry;
import org.aoju.bus.goalie.registry.DefaultAssetsRegistry;
import org.aoju.bus.goalie.registry.DefaultLimiterRegistry;
import org.aoju.bus.goalie.registry.LimiterRegistry;
import org.aoju.bus.starter.goalie.GoalieProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import reactor.netty.http.server.HttpServer;

@ConditionalOnWebApplication
@EnableConfigurationProperties(value={GoalieProperties.class})
public class GoalieConfiguration {
    @Autowired
    GoalieProperties goalieProperties;
    @Autowired(required=false)
    List<WebExceptionHandler> webExceptionHandlers;
    @Autowired(required=false)
    List<WebFilter> webFilters;

    @ConditionalOnMissingBean
    @Bean
    AssetsRegistry assetsRegistry() {
        return new DefaultAssetsRegistry();
    }

    @ConditionalOnMissingBean
    @Bean
    LimiterRegistry limiterRegistry() {
        return new DefaultLimiterRegistry();
    }

    @Bean
    WebFilter primaryFilter() {
        return new PrimaryFilter();
    }

    @Bean
    WebFilter decryptFilter() {
        return this.goalieProperties.getServer().getDecrypt().isEnabled() ? new DecryptFilter(this.goalieProperties.getServer().getDecrypt()) : null;
    }

    @Bean
    WebFilter authorizeFilter(Authorize authorize, AssetsRegistry registry) {
        return new AuthorizeFilter(authorize, registry);
    }

    @Bean
    WebFilter encryptFilter() {
        return this.goalieProperties.getServer().getEncrypt().isEnabled() ? new EncryptFilter(this.goalieProperties.getServer().getEncrypt()) : null;
    }

    @Bean
    WebFilter limitFilter(LimiterRegistry registry) {
        return this.goalieProperties.getServer().getLimit().isEnabled() ? new LimitFilter(registry) : null;
    }

    @Bean
    WebFilter formatFilter() {
        return new FormatFilter();
    }

    @Bean
    WebExceptionHandler webExceptionHandler() {
        return new GlobalExceptionHandler();
    }

    @Bean(initMethod="init", destroyMethod="destroy")
    Athlete athlete() {
        ApiRouterHandler apiRouterHandler = new ApiRouterHandler();
        RouterFunction routerFunction = RouterFunctions.route((RequestPredicate)RequestPredicates.path((String)this.goalieProperties.getServer().getPath()).and(RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED})), apiRouterHandler::handle);
        ServerCodecConfigurer configurer = ServerCodecConfigurer.create();
        configurer.defaultCodecs().maxInMemorySize(0x200000);
        WebHandler webHandler = RouterFunctions.toWebHandler((RouterFunction)routerFunction);
        HttpHandler handler = WebHttpHandlerBuilder.webHandler((WebHandler)webHandler).filters(filters -> filters.addAll(this.webFilters)).exceptionHandlers(handlers -> handlers.addAll(this.webExceptionHandlers)).codecConfigurer(configurer).build();
        ReactorHttpHandlerAdapter adapter = new ReactorHttpHandlerAdapter(handler);
        HttpServer server = HttpServer.create().port(this.goalieProperties.getServer().getPort()).handle((BiFunction)adapter);
        return new Athlete(server);
    }

    @Bean
    public WebMvcRegistrations customWebMvcRegistrations() {
        return this.goalieProperties.isCondition() ? null : new ApiWebMvcRegistrations();
    }
}

