/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.apache.cxf.interceptor;

import java.util.List;
import java.util.Map;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.config.TraceFilterConfig;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;
import org.aoju.bus.tracer.transport.SoapHeaderTransport;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.w3c.dom.Element;

abstract class AbstractTraceInInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected final Backend backend;
    private final HttpHeaderTransport httpJsonSerializer;
    private final SoapHeaderTransport httpSoapSerializer;
    private final TraceFilterConfig.Channel channel;
    private String profile;

    public AbstractTraceInInterceptor(String phase, TraceFilterConfig.Channel channel, Backend backend, String profile) {
        super(phase);
        this.channel = channel;
        this.backend = backend;
        this.profile = profile;
        this.httpJsonSerializer = new HttpHeaderTransport();
        this.httpSoapSerializer = new SoapHeaderTransport();
    }

    protected abstract boolean shouldHandleMessage(Message var1);

    public void handleMessage(Message message) {
        if (this.shouldHandleMessage(message)) {
            TraceFilterConfig filterConfiguration = this.backend.getConfiguration(this.profile);
            Logger.debug("Interceptor handles message!", new Object[0]);
            if (filterConfiguration.shouldProcessContext(this.channel)) {
                if (Boolean.TRUE.equals(message.getExchange().get((Object)"org.apache.cxf.rest.message"))) {
                    this.handleHttpMessage(message, filterConfiguration);
                } else {
                    try {
                        this.handleSoapMessage((SoapMessage)message, filterConfiguration);
                    }
                    catch (NoClassDefFoundError e) {
                        Logger.error("Should handle SOAP-message but it seems that cxf soap dependency is not on the classpath. Unable to parse Builder-Headers: {}", e.getMessage(), e);
                    }
                }
            }
        }
    }

    private void handleHttpMessage(Message message, TraceFilterConfig filterConfiguration) {
        List traceHeader;
        Map requestHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (null != requestHeaders && !requestHeaders.isEmpty() && null != (traceHeader = (List)requestHeaders.get("TPIC")) && !traceHeader.isEmpty()) {
            Map<String, String> parsedContext = this.httpJsonSerializer.parse(traceHeader);
            this.backend.putAll(filterConfiguration.filterDeniedParams(parsedContext, this.channel));
        }
    }

    private void handleSoapMessage(SoapMessage message, TraceFilterConfig filterConfiguration) {
        Header soapHeader = message.getHeader(Builder.SOAP_HEADER_QNAME);
        if (null != soapHeader) {
            Map<String, String> parsedContext = this.httpSoapSerializer.parseTpicHeader((Element)soapHeader.getObject());
            this.backend.putAll(filterConfiguration.filterDeniedParams(parsedContext, this.channel));
        }
    }
}

