/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.aoju.bus.core.codec.Base64Decoder;
import org.aoju.bus.core.codec.Base64Encoder;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Base64 {
    public static byte[] encode(byte[] arr, boolean lineSep) {
        return Base64Encoder.encode(arr, lineSep);
    }

    public static byte[] encodeUrlSafe(byte[] arr, boolean lineSep) {
        return Base64Encoder.encodeUrlSafe(arr, lineSep);
    }

    public static String encode(CharSequence source) {
        return Base64Encoder.encode(source);
    }

    public static String encodeUrlSafe(CharSequence source) {
        return Base64Encoder.encodeUrlSafe(source);
    }

    public static String encode(CharSequence source, String charset) {
        return Base64Encoder.encode(source, Charset.charset(charset));
    }

    public static String encodeUrlSafe(CharSequence source, String charset) {
        return Base64Encoder.encodeUrlSafe(source, Charset.charset(charset));
    }

    public static String encode(CharSequence source, java.nio.charset.Charset charset) {
        return Base64Encoder.encode(source, charset);
    }

    public static String encodeUrlSafe(CharSequence source, java.nio.charset.Charset charset) {
        return Base64Encoder.encodeUrlSafe(source, charset);
    }

    public static String encode(byte[] source) {
        return Base64Encoder.encode(source);
    }

    public static String encodeUrlSafe(byte[] source) {
        return Base64Encoder.encodeUrlSafe(source);
    }

    public static String encode(InputStream in) {
        return Base64Encoder.encode(IoKit.readBytes(in));
    }

    public static String encodeUrlSafe(InputStream in) {
        return Base64Encoder.encodeUrlSafe(IoKit.readBytes(in));
    }

    public static String encode(File file) {
        return Base64Encoder.encode(FileKit.readBytes(file));
    }

    public static String encodeUrlSafe(File file) {
        return Base64Encoder.encodeUrlSafe(FileKit.readBytes(file));
    }

    public static String encodeWithoutPadding(byte[] source) {
        return java.util.Base64.getEncoder().withoutPadding().encodeToString(source);
    }

    public static String encodeWithoutPadding(CharSequence source, String charset) {
        return Base64.encodeWithoutPadding(StringKit.bytes(source, charset));
    }

    public static byte[] encode(byte[] arr, boolean isMultiLine, boolean isUrlSafe) {
        return Base64Encoder.encode(arr, isMultiLine, isUrlSafe);
    }

    public static void encode(byte[] src, int srcPos, int srcLen, char[] dest, int destPos) {
        Base64Encoder.encode(src, srcPos, srcLen, dest, destPos);
    }

    public static String decodeStrGbk(CharSequence source) {
        return Base64Decoder.decodeStr(source, Charset.GBK);
    }

    public static String decodeStr(CharSequence source) {
        return Base64Decoder.decodeStr(source);
    }

    public static String decodeStr(CharSequence source, String charset) {
        return Base64Decoder.decodeStr(source, Charset.charset(charset));
    }

    public static String decodeStr(CharSequence source, java.nio.charset.Charset charset) {
        return Base64Decoder.decodeStr(source, charset);
    }

    public static File decodeToFile(CharSequence base64, File destFile) {
        return FileKit.writeBytes(Base64Decoder.decode(base64), destFile);
    }

    public static void decodeToStream(CharSequence base64, OutputStream out, boolean isCloseOut) {
        IoKit.write(out, isCloseOut, Base64Decoder.decode(base64));
    }

    public static byte[] decode(CharSequence base64) {
        return Base64Decoder.decode(base64);
    }

    public static byte[] decode(byte[] in) {
        return Base64Decoder.decode(in);
    }

    public static void decode(char[] ch, int off, int len, OutputStream out) {
        try {
            Base64Decoder.decode(ch, off, len, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isBase64(CharSequence base64) {
        return Base64.isBase64(StringKit.bytes(base64));
    }

    public static boolean isBase64(byte[] base64Bytes) {
        for (byte base64Byte : base64Bytes) {
            if (Base64Decoder.isBase64Code(base64Byte) || Base64.isWhiteSpace(base64Byte)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

