/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.instance;

import java.util.HashMap;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.instance.InstanceFactory;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Func;
import org.aoju.bus.core.lang.SimpleCache;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

@ThreadSafe
public final class Instances {
    private static final SimpleCache<String, Object> POOL = new SimpleCache(new HashMap());

    private Instances() {
    }

    public static <T> T singletion(Class<T> clazz) {
        return InstanceFactory.getInstance().singleton(clazz);
    }

    public static <T> T singletion(Class<T> clazz, String groupName) {
        return InstanceFactory.getInstance().singleton(clazz, groupName);
    }

    public static <T> T threadLocal(Class<T> clazz) {
        return InstanceFactory.getInstance().threadLocal(clazz);
    }

    public static <T> T threadSafe(Class<T> clazz) {
        return InstanceFactory.getInstance().threadSafe(clazz);
    }

    public static <T> T multiple(Class<T> clazz) {
        return InstanceFactory.getInstance().multiple(clazz);
    }

    public static <T> T singletion(Class<T> clazz, Object ... params) {
        Assert.notNull(clazz, "Class must be not null !", new Object[0]);
        String key = Instances.buildKey(clazz.getName(), params);
        return (T)Instances.singletion(key, () -> ReflectKit.newInstance(clazz, params));
    }

    public static <T> T singletion(String key, Func.Func0<T> supplier) {
        return (T)POOL.get(key, supplier::call);
    }

    public static <T> T singletion(String className, Object ... params) {
        Assert.notBlank(className, "Class name must be not blank !", new Object[0]);
        Class clazz = ClassKit.loadClass(className);
        return Instances.singletion(clazz, params);
    }

    public static void put(Object obj) {
        Assert.notNull(obj, "Bean object must be not null !", new Object[0]);
        Instances.put(obj.getClass().getName(), obj);
    }

    public static void put(String key, Object obj) {
        POOL.put(key, obj);
    }

    public static void remove(Class<?> clazz) {
        if (null != clazz) {
            Instances.remove(clazz.getName());
        }
    }

    public static void remove(String key) {
        POOL.remove(key);
    }

    public static void destroy() {
        POOL.clear();
    }

    public static String buildKey(String className, Object ... params) {
        if (ArrayKit.isEmpty(params)) {
            return className;
        }
        return StringKit.format("{}#{}", className, ArrayKit.join(params, (CharSequence)"_"));
    }
}

